//
//  QSIActivateRelay.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIActivateRelayProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIActivateRelay Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIActivateRelay Private Class Methods
//
@interface QSIActivateRelay (QSIActivateRelayPrivateClassMethods)
@end // @interface QSIActivateRelay (QSIActivateRelayPrivateClassMethods)

@implementation QSIActivateRelay (QSIActivateRelayPrivateClassMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayPrivateClassMethods)

//
// QSIActivateRelay Private Instance Methods
//
@interface QSIActivateRelay (QSIActivateRelayPrivateInstanceMethods)
@end // @interface QSIActivateRelay (QSIActivateRelayPrivateInstanceMethods)

@implementation QSIActivateRelay (QSIActivateRelayPrivateInstanceMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIActivateRelay Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIActivateRelay Infrastructure Class Methods
//
@implementation QSIActivateRelay (QSIActivateRelayInfrastructureClassMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayInfrastructureClassMethods)

//
// QSIActivateRelay Infrastructure Instance Methods
//
@implementation QSIActivateRelay (QSIActivateRelayInfrastructureInstanceMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIActivateRelay Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIActivateRelay Overridden Class Methods
//
@implementation QSIActivateRelay (QSIActivateRelayOverriddenClassMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayOverriddenClassMethods)

//
// QSIActivateRelay Overridden Instance Methods
//
@implementation QSIActivateRelay (QSIActivateRelayOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSIActivateRelayCommandBuffer  *commandBuffer = (QSIActivateRelayCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  [translator set16Bits:&commandBuffer->_xRelay fromValue:_xRelay];
  [translator set16Bits:&commandBuffer->_yRelay fromValue:_yRelay];
} // end -preprocessCommandBuffer
@end // @implementation QSIActivateRelay (QSIActivateRelayOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIActivateRelay Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIActivateRelay Public Class Methods
//
@implementation QSIActivateRelay (QSIActivateRelayPublicClassMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayPublicClassMethods)

//
// QSIActivateRelay Public Instance Methods
//
@implementation QSIActivateRelay (QSIActivateRelayPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
               xRelay : (uint16_t) anXRelay
            andYRelay : (uint16_t) aYRelay
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIActivateRelayCommand
          andCommandBufferSize:sizeof(QSIActivateRelayCommandBuffer)];
  if (self != nil)
  {
    _xRelay = anXRelay;
    _yRelay = aYRelay;
  }

  return (self);
} // end -initUsingComms:xRelay:andYRelay:
@end // @implementation QSIActivateRelay (QSIActivateRelayPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIActivateRelay Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIActivateRelay Protected Class Methods
//
@implementation QSIActivateRelay (QSIActivateRelayProtectedClassMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayProtectedClassMethods)

//
// QSIActivateRelay Protected Instance Methods
//
@implementation QSIActivateRelay (QSIActivateRelayProtectedInstanceMethods)
@end // @implementation QSIActivateRelay (QSIActivateRelayProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIActivateRelay
************************************************************************************************
***********************************************************************************************/

@implementation QSIActivateRelay
@end // @implementation QSIActivateRelay
