//
//  QSICanAbortExposure.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICanAbortExposureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICanAbortExposure Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanAbortExposure Private Class Methods
//
@interface QSICanAbortExposure (QSICanAbortExposurePrivateClassMethods)
@end // @interface QSICanAbortExposure (QSICanAbortExposurePrivateClassMethods)

@implementation QSICanAbortExposure (QSICanAbortExposurePrivateClassMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposurePrivateClassMethods)

//
// QSICanAbortExposure Private Instance Methods
//
@interface QSICanAbortExposure (QSICanAbortExposurePrivateInstanceMethods)
@end // @interface QSICanAbortExposure (QSICanAbortExposurePrivateInstanceMethods)

@implementation QSICanAbortExposure (QSICanAbortExposurePrivateInstanceMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposurePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICanAbortExposure Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanAbortExposure Infrastructure Class Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureInfrastructureClassMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposureInfrastructureClassMethods)

//
// QSICanAbortExposure Infrastructure Instance Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureInfrastructureInstanceMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICanAbortExposure Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanAbortExposure Overridden Class Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureOverriddenClassMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposureOverriddenClassMethods)

//
// QSICanAbortExposure Overridden Instance Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSICanAbortExposureResponseBuffer  *responseBuffer = (QSICanAbortExposureResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _canAbortExposure = [translator getBoolFromSource:&responseBuffer->_canAbort];
} // end -postprocessResponseBuffer
@end // @implementation QSICanAbortExposure (QSICanAbortExposureOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICanAbortExposure Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanAbortExposure Public Class Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposurePublicClassMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposurePublicClassMethods)

//
// QSICanAbortExposure Public Instance Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposurePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSICanAbortExposureCommand
          andResponseBufferSize:sizeof(QSICanAbortExposureResponseBuffer)]);
} // end -initUsingComms:

- (bool) canAbortExposure
{
  return (_canAbortExposure);
} // end -canAbortExposure
@end // @implementation QSICanAbortExposure (QSICanAbortExposurePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICanAbortExposure Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanAbortExposure Protected Class Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureProtectedClassMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposureProtectedClassMethods)

//
// QSICanAbortExposure Protected Instance Methods
//
@implementation QSICanAbortExposure (QSICanAbortExposureProtectedInstanceMethods)
@end // @implementation QSICanAbortExposure (QSICanAbortExposureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICanAbortExposure
************************************************************************************************
***********************************************************************************************/

@implementation QSICanAbortExposure
@end // @implementation QSICanAbortExposure
