//
//  QSICanStopExposure.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICanStopExposureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICanStopExposure Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanStopExposure Private Class Methods
//
@interface QSICanStopExposure (QSICanStopExposurePrivateClassMethods)
@end // @interface QSICanStopExposure (QSICanStopExposurePrivateClassMethods)

@implementation QSICanStopExposure (QSICanStopExposurePrivateClassMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposurePrivateClassMethods)

//
// QSICanStopExposure Private Instance Methods
//
@interface QSICanStopExposure (QSICanStopExposurePrivateInstanceMethods)
@end // @interface QSICanStopExposure (QSICanStopExposurePrivateInstanceMethods)

@implementation QSICanStopExposure (QSICanStopExposurePrivateInstanceMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposurePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICanStopExposure Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanStopExposure Infrastructure Class Methods
//
@implementation QSICanStopExposure (QSICanStopExposureInfrastructureClassMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposureInfrastructureClassMethods)

//
// QSICanStopExposure Infrastructure Instance Methods
//
@implementation QSICanStopExposure (QSICanStopExposureInfrastructureInstanceMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICanStopExposure Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanStopExposure Overridden Class Methods
//
@implementation QSICanStopExposure (QSICanStopExposureOverriddenClassMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposureOverriddenClassMethods)

//
// QSICanStopExposure Overridden Instance Methods
//
@implementation QSICanStopExposure (QSICanStopExposureOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSICanStopExposureResponseBuffer  *responseBuffer = (QSICanStopExposureResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _canStopExposure = [translator getBoolFromSource:&responseBuffer->_canStop];
} // end -postprocessResponseBuffer
@end // @implementation QSICanStopExposure (QSICanStopExposureOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICanStopExposure Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanStopExposure Public Class Methods
//
@implementation QSICanStopExposure (QSICanStopExposurePublicClassMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposurePublicClassMethods)

//
// QSICanStopExposure Public Instance Methods
//
@implementation QSICanStopExposure (QSICanStopExposurePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSICanStopExposureCommand
          andResponseBufferSize:sizeof(QSICanStopExposureResponseBuffer)]);
} // end -initUsingComms:

- (bool) canStopExposure
{
  return (_canStopExposure);
} // end -canStopExposure
@end // @implementation QSICanStopExposure (QSICanStopExposurePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICanStopExposure Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICanStopExposure Protected Class Methods
//
@implementation QSICanStopExposure (QSICanStopExposureProtectedClassMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposureProtectedClassMethods)

//
// QSICanStopExposure Protected Instance Methods
//
@implementation QSICanStopExposure (QSICanStopExposureProtectedInstanceMethods)
@end // @implementation QSICanStopExposure (QSICanStopExposureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICanStopExposure
************************************************************************************************
***********************************************************************************************/

@implementation QSICanStopExposure
@end // @implementation QSICanStopExposure
