//
//  QSIGetAutoZero.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetAutoZeroProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetAutoZero Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAutoZero Private Class Methods
//
@interface QSIGetAutoZero (QSIGetAutoZeroPrivateClassMethods)
@end // @interface QSIGetAutoZero (QSIGetAutoZeroPrivateClassMethods)

@implementation QSIGetAutoZero (QSIGetAutoZeroPrivateClassMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroPrivateClassMethods)

//
// QSIGetAutoZero Private Instance Methods
//
@interface QSIGetAutoZero (QSIGetAutoZeroPrivateInstanceMethods)
@end // @interface QSIGetAutoZero (QSIGetAutoZeroPrivateInstanceMethods)

@implementation QSIGetAutoZero (QSIGetAutoZeroPrivateInstanceMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAutoZero Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAutoZero Infrastructure Class Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroInfrastructureClassMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroInfrastructureClassMethods)

//
// QSIGetAutoZero Infrastructure Instance Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroInfrastructureInstanceMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAutoZero Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAutoZero Overridden Class Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroOverriddenClassMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroOverriddenClassMethods)

//
// QSIGetAutoZero Overridden Instance Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIGetAutoZeroResponseBuffer  *responseBuffer = (QSIGetAutoZeroResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._zeroEnabled  = [translator getBoolFromSource:&responseBuffer->_zeroEnabled];
  _results._zeroLevel    = [translator get16BitsFromSource:&responseBuffer->_zeroLevel];
  _results._pixelCount   = [translator get16BitsFromSource:&responseBuffer->_pixelCount];
} // end -postprocessResponseBuffer
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAutoZero Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAutoZero Public Class Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroPublicClassMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroPublicClassMethods)

//
// QSIGetAutoZero Public Instance Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
   andAutoZeroResults : (QSICameraAutoZero *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetAutoZeroCommand
         andResponseBufferSize:sizeof(QSIGetAutoZeroResponseBuffer)];
  if (self != nil)
  {
    _results = aResults;
  }

  return (self);
} // end -initUsingComms:
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAutoZero Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAutoZero Protected Class Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroProtectedClassMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroProtectedClassMethods)

//
// QSIGetAutoZero Protected Instance Methods
//
@implementation QSIGetAutoZero (QSIGetAutoZeroProtectedInstanceMethods)
@end // @implementation QSIGetAutoZero (QSIGetAutoZeroProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetAutoZero
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetAutoZero
@end // @implementation QSIGetAutoZero
