//
//  QSIGetTemperature.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetTemperatureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetTemperature Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetTemperature Private Class Methods
//
@interface QSIGetTemperature (QSIGetTemperaturePrivateClassMethods)
@end // @interface QSIGetTemperature (QSIGetTemperaturePrivateClassMethods)

@implementation QSIGetTemperature (QSIGetTemperaturePrivateClassMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperaturePrivateClassMethods)

//
// QSIGetTemperature Private Instance Methods
//
@interface QSIGetTemperature (QSIGetTemperaturePrivateInstanceMethods)
@end // @interface QSIGetTemperature (QSIGetTemperaturePrivateInstanceMethods)

@implementation QSIGetTemperature (QSIGetTemperaturePrivateInstanceMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperaturePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetTemperature Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetTemperature Infrastructure Class Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureInfrastructureClassMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperatureInfrastructureClassMethods)

//
// QSIGetTemperature Infrastructure Instance Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureInfrastructureInstanceMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperatureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetTemperature Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetTemperature Overridden Class Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureOverriddenClassMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperatureOverriddenClassMethods)

//
// QSIGetTemperature Overridden Instance Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureOverriddenInstanceMethods)
- (uint8_t) attemptLimit
{
  return (3);
} // end -attemptLimit

- (void) postprocessResponseBuffer
{
  QSIGetTemperatureResponseBuffer  *responseBuffer = (QSIGetTemperatureResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._coolerState = responseBuffer->_coolerState;

  _results._coolerTemperature =  ((int16_t) [translator get16BitsFromSource:&responseBuffer->_coolerTemperature]) / 100.0;
  _results._ambientTemperature = ((int16_t) [translator get16BitsFromSource:&responseBuffer->_ambientTemperature]) / 100.0 ;
  _results._coolerPower = [translator get16BitsFromSource:&responseBuffer->_coolerPower] / 100.0;
} // end -postprocessResponseBuffer
@end // @implementation QSIGetTemperature (QSIGetTemperatureOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetTemperature Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetTemperature Public Class Methods
//
@implementation QSIGetTemperature (QSIGetTemperaturePublicClassMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperaturePublicClassMethods)

//
// QSIGetTemperature Public Instance Methods
//
@implementation QSIGetTemperature (QSIGetTemperaturePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
andTemperatureResults : (QSICameraTemperature *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetTemperatureCommand
         andResponseBufferSize:sizeof(QSIGetTemperatureResponseBuffer)];
  if (self != nil)
  {
    _results = aResults;
  }

  return (self);
} // end -initUsingComms:andTemperatureResults:
@end // @implementation QSIGetTemperature (QSIGetTemperaturePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetTemperature Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetTemperature Protected Class Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureProtectedClassMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperatureProtectedClassMethods)

//
// QSIGetTemperature Protected Instance Methods
//
@implementation QSIGetTemperature (QSIGetTemperatureProtectedInstanceMethods)
@end // @implementation QSIGetTemperature (QSIGetTemperatureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetTemperature
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetTemperature
@end // @implementation QSIGetTemperature
