//
//  QSIIsRelayDone.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIIsRelayDoneProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIIsRelayDone Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIIsRelayDone Private Class Methods
//
@interface QSIIsRelayDone (QSIIsRelayDonePrivateClassMethods)
@end // @interface QSIIsRelayDone (QSIIsRelayDonePrivateClassMethods)

@implementation QSIIsRelayDone (QSIIsRelayDonePrivateClassMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDonePrivateClassMethods)

//
// QSIIsRelayDone Private Instance Methods
//
@interface QSIIsRelayDone (QSIIsRelayDonePrivateInstanceMethods)
@end // @interface QSIIsRelayDone (QSIIsRelayDonePrivateInstanceMethods)

@implementation QSIIsRelayDone (QSIIsRelayDonePrivateInstanceMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDonePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIIsRelayDone Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIIsRelayDone Infrastructure Class Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneInfrastructureClassMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneInfrastructureClassMethods)

//
// QSIIsRelayDone Infrastructure Instance Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneInfrastructureInstanceMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIIsRelayDone Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIIsRelayDone Overridden Class Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneOverriddenClassMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneOverriddenClassMethods)

//
// QSIIsRelayDone Overridden Instance Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIIsRelayDoneResponseBuffer  *responseBuffer = (QSIIsRelayDoneResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _relayDone = [translator getBoolFromSource:&responseBuffer->_relayDone];
} // end -postprocessResponseBuffer
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIIsRelayDone Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIIsRelayDone Public Class Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDonePublicClassMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDonePublicClassMethods)

//
// QSIIsRelayDone Public Instance Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDonePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSIIsRelayDoneCommand
          andResponseBufferSize:sizeof(QSIIsRelayDoneResponseBuffer)]);
} // end -initUsingComms:

- (bool) relayDone
{
  return (_relayDone);
} // end -relayDone
@end // @implementation QSIIsRelayDone (QSIIsRelayDonePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIIsRelayDone Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIIsRelayDone Protected Class Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneProtectedClassMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneProtectedClassMethods)

//
// QSIIsRelayDone Protected Instance Methods
//
@implementation QSIIsRelayDone (QSIIsRelayDoneProtectedInstanceMethods)
@end // @implementation QSIIsRelayDone (QSIIsRelayDoneProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIIsRelayDone
************************************************************************************************
***********************************************************************************************/

@implementation QSIIsRelayDone
@end // @implementation QSIIsRelayDone
