//
//  QSISendAdvancedSettings.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSISendAdvancedSettingsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSISendAdvancedSettings Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISendAdvancedSettings Private Class Methods
//
@interface QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateClassMethods)
@end // @interface QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateClassMethods)

@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateClassMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateClassMethods)

//
// QSISendAdvancedSettings Private Instance Methods
//
@interface QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateInstanceMethods)
@end // @interface QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateInstanceMethods)

@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateInstanceMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSISendAdvancedSettings Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISendAdvancedSettings Infrastructure Class Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsInfrastructureClassMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsInfrastructureClassMethods)

//
// QSISendAdvancedSettings Infrastructure Instance Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsInfrastructureInstanceMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISendAdvancedSettings Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISendAdvancedSettings Overridden Class Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsOverriddenClassMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsOverriddenClassMethods)

//
// QSISendAdvancedSettings Overridden Instance Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSISendAdvancedSettingsCommandBuffer  *commandBuffer = (QSISendAdvancedSettingsCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  commandBuffer->_antiBloomingIndex = _parameters._antiBloomingIndex;
  commandBuffer->_cameraGainIndex   = _parameters._cameraGainIndex;
  commandBuffer->_fanModeIndex      = _parameters._fanModeIndex;
  commandBuffer->_preExposureFlushIndex = _parameters._preExposureFlushIndex;
  commandBuffer->_shutterPriorityIndex  = _parameters._shutterPriorityIndex;

  [translator setBool:&commandBuffer->_showDownloadProgress fromValue:_parameters._showDownloadProgress];
  [translator setBool:&commandBuffer->_ledIndicatorOn fromValue:_parameters._ledIndicatorOn];
  [translator setBool:&commandBuffer->_optimizeReadoutSpeed fromValue:_parameters._optimizeReadoutSpeed];
  [translator setBool:&commandBuffer->_soundOn fromValue:_parameters._soundOn];
} // end -preprocessCommandBuffer
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISendAdvancedSettings Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISendAdvancedSettings Public Class Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPublicClassMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPublicClassMethods)

//
// QSISendAdvancedSettings Public Instance Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
andSettingsParameters : (QSICameraAdvancedSettingsParameters *) aParameters
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSISendAdvancedSettingsCommand
          andCommandBufferSize:sizeof(QSISendAdvancedSettingsCommandBuffer)];
  if (self != nil)
  {
    _parameters = aParameters;
  }

  return (self);
} // end -initUsingComms:andSettingsParameters:
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISendAdvancedSettings Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISendAdvancedSettings Protected Class Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedClassMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedClassMethods)

//
// QSISendAdvancedSettings Protected Instance Methods
//
@implementation QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedInstanceMethods)
@end // @implementation QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSISendAdvancedSettings
************************************************************************************************
***********************************************************************************************/

@implementation QSISendAdvancedSettings
@end // @implementation QSISendAdvancedSettings
