//
//  QSISendAdvancedSettingsProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICommandProtected.h"
#import "QSISendAdvancedSettings.h"

#define QSISendAdvancedSettingsCommand  ((QSICommandId) 0x4d)

typedef struct __attribute__((packed)) _QSISendAdvancedSettingsCommandBuffer
{
  QSICommandBufferHeader  _header;

  uint8_t _ledIndicatorOn;
  uint8_t _soundOn;
  uint8_t _fanModeIndex;
  uint8_t _cameraGainIndex;
  uint8_t _shutterPriorityIndex;
  uint8_t _antiBloomingIndex;
  uint8_t _preExposureFlushIndex;
  uint8_t _showDownloadProgress;
  uint8_t _optimizeReadoutSpeed;
} QSISendAdvancedSettingsCommandBuffer;

@interface QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedClassMethods)
@end // @interface QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedClassMethods)

@interface QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedInstanceMethods)
@end // @interface QSISendAdvancedSettings (QSISendAdvancedSettingsProtectedInstanceMethods)
