//
//  QSISetAltMode1.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSISetAltMode1Protected.h"

/***********************************************************************************************
************************************************************************************************
* QSISetAltMode1 Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetAltMode1 Private Class Methods
//
@interface QSISetAltMode1 (QSISetAltMode1PrivateClassMethods)
@end // @interface QSISetAltMode1 (QSISetAltMode1PrivateClassMethods)

@implementation QSISetAltMode1 (QSISetAltMode1PrivateClassMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1PrivateClassMethods)

//
// QSISetAltMode1 Private Instance Methods
//
@interface QSISetAltMode1 (QSISetAltMode1PrivateInstanceMethods)
@end // @interface QSISetAltMode1 (QSISetAltMode1PrivateInstanceMethods)

@implementation QSISetAltMode1 (QSISetAltMode1PrivateInstanceMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1PrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSISetAltMode1 Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetAltMode1 Infrastructure Class Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1InfrastructureClassMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1InfrastructureClassMethods)

//
// QSISetAltMode1 Infrastructure Instance Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1InfrastructureInstanceMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1InfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetAltMode1 Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetAltMode1 Overridden Class Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1OverriddenClassMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1OverriddenClassMethods)

//
// QSISetAltMode1 Overridden Instance Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1OverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSISetAltMode1CommandBuffer  *commandBuffer = (QSISetAltMode1CommandBuffer *) [self commandBuffer];

  commandBuffer->_altMode1 = _altMode1;
} // end -preprocessCommandBuffer
@end // @implementation QSISetAltMode1 (QSISetAltMode1OverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetAltMode1 Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetAltMode1 Public Class Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1PublicClassMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1PublicClassMethods)

//
// QSISetAltMode1 Public Instance Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1PublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
          andAltMode1 : (uint8_t) anAltMode1
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSISetAltMode1Command
          andCommandBufferSize:sizeof(QSISetAltMode1CommandBuffer)];
  if (self != nil)
  {
    _altMode1 = anAltMode1;
  }

  return (self);
} // end -initUsingComms:andAltMode1
@end // @implementation QSISetAltMode1 (QSISetAltMode1PublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetAltMode1 Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetAltMode1 Protected Class Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1ProtectedClassMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1ProtectedClassMethods)

//
// QSISetAltMode1 Protected Instance Methods
//
@implementation QSISetAltMode1 (QSISetAltMode1ProtectedInstanceMethods)
@end // @implementation QSISetAltMode1 (QSISetAltMode1ProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSISetAltMode1
************************************************************************************************
***********************************************************************************************/

@implementation QSISetAltMode1
@end // @implementation QSISetAltMode1
