//
//  QSISetFilterWheel.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSISetFilterWheelProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSISetFilterWheel Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetFilterWheel Private Class Methods
//
@interface QSISetFilterWheel (QSISetFilterWheelPrivateClassMethods)
@end // @interface QSISetFilterWheel (QSISetFilterWheelPrivateClassMethods)

@implementation QSISetFilterWheel (QSISetFilterWheelPrivateClassMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelPrivateClassMethods)

//
// QSISetFilterWheel Private Instance Methods
//
@interface QSISetFilterWheel (QSISetFilterWheelPrivateInstanceMethods)
@end // @interface QSISetFilterWheel (QSISetFilterWheelPrivateInstanceMethods)

@implementation QSISetFilterWheel (QSISetFilterWheelPrivateInstanceMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSISetFilterWheel Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetFilterWheel Infrastructure Class Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelInfrastructureClassMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelInfrastructureClassMethods)

//
// QSISetFilterWheel Infrastructure Instance Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelInfrastructureInstanceMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetFilterWheel Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetFilterWheel Overridden Class Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelOverriddenClassMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelOverriddenClassMethods)

//
// QSISetFilterWheel Overridden Instance Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSISetFilterWheelCommandBuffer  *commandBuffer = (QSISetFilterWheelCommandBuffer *) [self commandBuffer];

  // We have a filter position; we need to specify an index for the command.
  commandBuffer->_filterIndex = _filterPosition - 1;
} // end -preprocessCommandBuffer
@end // @implementation QSISetFilterWheel (QSISetFilterWheelOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetFilterWheel Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetFilterWheel Public Class Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelPublicClassMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelPublicClassMethods)

//
// QSISetFilterWheel Public Instance Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
    andFilterPosition : (uint8_t) aFilterPosition
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSISetFilterWheelCommand
          andCommandBufferSize:sizeof(QSISetFilterWheelCommandBuffer)];
  if (self != nil)
  {
    _filterPosition = aFilterPosition;
  }

  return (self);
} // end -initUsingComms:xRelay:andYRelay:
@end // @implementation QSISetFilterWheel (QSISetFilterWheelPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetFilterWheel Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetFilterWheel Protected Class Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelProtectedClassMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelProtectedClassMethods)

//
// QSISetFilterWheel Protected Instance Methods
//
@implementation QSISetFilterWheel (QSISetFilterWheelProtectedInstanceMethods)
@end // @implementation QSISetFilterWheel (QSISetFilterWheelProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSISetFilterWheel
************************************************************************************************
***********************************************************************************************/

@implementation QSISetFilterWheel
@end // @implementation QSISetFilterWheel
