//
//  QSISetTemperature.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSISetTemperatureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSISetTemperature Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetTemperature Private Class Methods
//
@interface QSISetTemperature (QSISetTemperaturePrivateClassMethods)
@end // @interface QSISetTemperature (QSISetTemperaturePrivateClassMethods)

@implementation QSISetTemperature (QSISetTemperaturePrivateClassMethods)
@end // @implementation QSISetTemperature (QSISetTemperaturePrivateClassMethods)

//
// QSISetTemperature Private Instance Methods
//
@interface QSISetTemperature (QSISetTemperaturePrivateInstanceMethods)
@end // @interface QSISetTemperature (QSISetTemperaturePrivateInstanceMethods)

@implementation QSISetTemperature (QSISetTemperaturePrivateInstanceMethods)
@end // @implementation QSISetTemperature (QSISetTemperaturePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSISetTemperature Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetTemperature Infrastructure Class Methods
//
@implementation QSISetTemperature (QSISetTemperatureInfrastructureClassMethods)
@end // @implementation QSISetTemperature (QSISetTemperatureInfrastructureClassMethods)

//
// QSISetTemperature Infrastructure Instance Methods
//
@implementation QSISetTemperature (QSISetTemperatureInfrastructureInstanceMethods)
@end // @implementation QSISetTemperature (QSISetTemperatureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetTemperature Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetTemperature Overridden Class Methods
//
@implementation QSISetTemperature (QSISetTemperatureOverriddenClassMethods)
@end // @implementation QSISetTemperature (QSISetTemperatureOverriddenClassMethods)

//
// QSISetTemperature Overridden Instance Methods
//
@implementation QSISetTemperature (QSISetTemperatureOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSISetTemperatureCommandBuffer  *commandBuffer = (QSISetTemperatureCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  [translator setBool:&commandBuffer->_coolerOn fromValue:_parameters._coolerOn];
  [translator setBool:&commandBuffer->_goToAmbient fromValue:_parameters._goToAmbient];
  [translator set16Bits:&commandBuffer->_setPoint fromValue:_parameters._setPoint * 100];
} // end -preprocessCommandBuffer
@end // @implementation QSISetTemperature (QSISetTemperatureOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetTemperature Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetTemperature Public Class Methods
//
@implementation QSISetTemperature (QSISetTemperaturePublicClassMethods)
@end // @implementation QSISetTemperature (QSISetTemperaturePublicClassMethods)

//
// QSISetTemperature Public Instance Methods
//
@implementation QSISetTemperature (QSISetTemperaturePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
andTemperatureParameters : (QSICameraTemperatureParameters *) aParameters
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSISetTemperatureCommand
          andCommandBufferSize:sizeof(QSISetTemperatureCommandBuffer)];
  if (self != nil)
  {
    _parameters = aParameters;
  }

  return (self);
} // end -initUsingComms:andTemperatureParameters:
@end // @implementation QSISetTemperature (QSISetTemperaturePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetTemperature Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetTemperature Protected Class Methods
//
@implementation QSISetTemperature (QSISetTemperatureProtectedClassMethods)
@end // @implementation QSISetTemperature (QSISetTemperatureProtectedClassMethods)

//
// QSISetTemperature Protected Instance Methods
//
@implementation QSISetTemperature (QSISetTemperatureProtectedInstanceMethods)
@end // @implementation QSISetTemperature (QSISetTemperatureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSISetTemperature
************************************************************************************************
***********************************************************************************************/

@implementation QSISetTemperature
@end // @implementation QSISetTemperature
