//
//  QSIStartExposure.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIStartExposureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIStartExposure Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposure Private Class Methods
//
@interface QSIStartExposure (QSIStartExposurePrivateClassMethods)
@end // @interface QSIStartExposure (QSIStartExposurePrivateClassMethods)

@implementation QSIStartExposure (QSIStartExposurePrivateClassMethods)
@end // @implementation QSIStartExposure (QSIStartExposurePrivateClassMethods)

//
// QSIStartExposure Private Instance Methods
//
@interface QSIStartExposure (QSIStartExposurePrivateInstanceMethods)
@end // @interface QSIStartExposure (QSIStartExposurePrivateInstanceMethods)

@implementation QSIStartExposure (QSIStartExposurePrivateInstanceMethods)
@end // @implementation QSIStartExposure (QSIStartExposurePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIStartExposure Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposure Infrastructure Class Methods
//
@implementation QSIStartExposure (QSIStartExposureInfrastructureClassMethods)
@end // @implementation QSIStartExposure (QSIStartExposureInfrastructureClassMethods)

//
// QSIStartExposure Infrastructure Instance Methods
//
@implementation QSIStartExposure (QSIStartExposureInfrastructureInstanceMethods)
@end // @implementation QSIStartExposure (QSIStartExposureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposure Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposure Overridden Class Methods
//
@implementation QSIStartExposure (QSIStartExposureOverriddenClassMethods)
@end // @implementation QSIStartExposure (QSIStartExposureOverriddenClassMethods)

//
// QSIStartExposure Overridden Instance Methods
//
@implementation QSIStartExposure (QSIStartExposureOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSIStartExposureCommandBuffer  *commandBuffer = (QSIStartExposureCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  [translator set24Bits:&commandBuffer->_duration fromValue:_parameters._duration];
  [translator set16Bits:&commandBuffer->_columnOffset fromValue:_parameters._startingColumn];
  [translator set16Bits:&commandBuffer->_rowOffset fromValue:_parameters._startingRow];
  [translator set16Bits:&commandBuffer->_columnsToRead fromValue:_parameters._width];
  [translator set16Bits:&commandBuffer->_rowsToRead fromValue:_parameters._height];

  commandBuffer->_yBinning  = _parameters._rowBinning;
  commandBuffer->_xBinning  = _parameters._columnBinning;

  [translator setBool:&commandBuffer->_openShutter fromValue:_parameters._openShutter];
  [translator setBool:&commandBuffer->_fastReadout fromValue:_parameters._fastReadout];
  [translator setBool:&commandBuffer->_holdShutterOpen fromValue:_parameters._holdShutterOpen];
} // end -preprocessCommandBuffer
@end // @implementation QSIStartExposure (QSIStartExposureOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposure Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposure Public Class Methods
//
@implementation QSIStartExposure (QSIStartExposurePublicClassMethods)
@end // @implementation QSIStartExposure (QSIStartExposurePublicClassMethods)

//
// QSIStartExposure Public Instance Methods
//
@implementation QSIStartExposure (QSIStartExposurePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
andExposureParameters : (QSICameraExposureParameters *) aParameters
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIStartExposureCommand
          andCommandBufferSize:sizeof(QSIStartExposureCommandBuffer)];
  if (self != nil)
  {
    _parameters = aParameters;
  }

  return (self);
} // end -initUsingComms:andExposureParameters:
@end // @implementation QSIStartExposure (QSIStartExposurePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposure Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposure Protected Class Methods
//
@implementation QSIStartExposure (QSIStartExposureProtectedClassMethods)
@end // @implementation QSIStartExposure (QSIStartExposureProtectedClassMethods)

//
// QSIStartExposure Protected Instance Methods
//
@implementation QSIStartExposure (QSIStartExposureProtectedInstanceMethods)
@end // @implementation QSIStartExposure (QSIStartExposureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIStartExposure
************************************************************************************************
***********************************************************************************************/

@implementation QSIStartExposure
@end // @implementation QSIStartExposure
