//
//  QSIStartExposureExtended.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIStartExposureExtendedProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIStartExposureExtended Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposureExtended Private Class Methods
//
@interface QSIStartExposureExtended (QSIStartExposureExtendedPrivateClassMethods)
@end // @interface QSIStartExposureExtended (QSIStartExposureExtendedPrivateClassMethods)

@implementation QSIStartExposureExtended (QSIStartExposureExtendedPrivateClassMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedPrivateClassMethods)

//
// QSIStartExposureExtended Private Instance Methods
//
@interface QSIStartExposureExtended (QSIStartExposureExtendedPrivateInstanceMethods)
@end // @interface QSIStartExposureExtended (QSIStartExposureExtendedPrivateInstanceMethods)

@implementation QSIStartExposureExtended (QSIStartExposureExtendedPrivateInstanceMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIStartExposureExtended Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposureExtended Infrastructure Class Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedInfrastructureClassMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedInfrastructureClassMethods)

//
// QSIStartExposureExtended Infrastructure Instance Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedInfrastructureInstanceMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposureExtended Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposureExtended Overridden Class Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedOverriddenClassMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedOverriddenClassMethods)

//
// QSIStartExposureExtended Overridden Instance Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSIStartExposureExtendedCommandBuffer  *commandBuffer = (QSIStartExposureExtendedCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  [translator set24Bits:&commandBuffer->_duration fromValue:_parameters._duration];
  commandBuffer->_durationUsec = _parameters._durationUsec;

  [translator set16Bits:&commandBuffer->_columnOffset fromValue:_parameters._startingColumn];
  [translator set16Bits:&commandBuffer->_rowOffset fromValue:_parameters._startingRow];
  [translator set16Bits:&commandBuffer->_columnsToRead fromValue:_parameters._width];
  [translator set16Bits:&commandBuffer->_rowsToRead fromValue:_parameters._height];
  [translator set16Bits:&commandBuffer->_yBinning fromValue:_parameters._rowBinning];
  [translator set16Bits:&commandBuffer->_xBinning fromValue:_parameters._columnBinning];
  [translator setBool:&commandBuffer->_openShutter fromValue:_parameters._openShutter];
  [translator setBool:&commandBuffer->_fastReadout fromValue:_parameters._fastReadout];
  [translator setBool:&commandBuffer->_holdShutterOpen fromValue:_parameters._holdShutterOpen];
  [translator setBool:&commandBuffer->_useExternalTrigger fromValue:_parameters._useExternalTrigger];
  [translator setBool:&commandBuffer->_strobeShutterOutput fromValue:_parameters._strobeShutterOutput];
  [translator set16Bits:&commandBuffer->_repeatCount fromValue:_parameters._repeatCount];
  [translator setBool:&commandBuffer->_probeForImplemented fromValue:_parameters._probeForImplemented];
} // end -preprocessCommandBuffer
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposureExtended Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposureExtended Public Class Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedPublicClassMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedPublicClassMethods)

//
// QSIStartExposureExtended Public Instance Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
andExposureParameters : (QSICameraExposureParameters *) aParameters;
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIStartExposureExtendedCommand
          andCommandBufferSize:sizeof(QSIStartExposureExtendedCommandBuffer)];
  if (self != nil)
  {
    _parameters = aParameters;
  }

  return (self);
} // end -initUsingComms:andExposureParameters:
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIStartExposureExtended Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIStartExposureExtended Protected Class Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedProtectedClassMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedProtectedClassMethods)

//
// QSIStartExposureExtended Protected Instance Methods
//
@implementation QSIStartExposureExtended (QSIStartExposureExtendedProtectedInstanceMethods)
@end // @implementation QSIStartExposureExtended (QSIStartExposureExtendedProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIStartExposureExtended
************************************************************************************************
***********************************************************************************************/

@implementation QSIStartExposureExtended
@end // @implementation QSIStartExposureExtended
