//
//  QSIEndian.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

@interface QSIEndian : QSIObject
{
@private
}
@end // @interface QSIEndian : QSIObject

@interface QSIEndian (QSIEndianPublicClassMethods)
@end // @interface QSIEndian (QSIEndianPublicClassMethods)

@interface QSIEndian (QSIEndianPublicInstanceMethods)
- (bool) getBoolFromSource : (void *) aSource;
- (uint16_t) get16BitsFromSource : (void *) aSource;
- (uint32_t) get24BitsFromSource : (void *) aSource;
- (uint32_t) get32BitsFromSource : (void *) aSource;

- (void) setBool : (void *) aDestination
       fromValue : (bool) aValue;
- (void) set16Bits : (void *) aDestination
         fromValue : (uint16_t) aValue;
- (void) set24Bits : (void *) aDestination
         fromValue : (uint32_t) aValue;
- (void) set32Bits : (void *) aDestination
         fromValue : (uint32_t) aValue;

- (void) setString : (void *) aDestinationString
       ofMaxLength : (uint8_t) aMaxDestinationLength
        fromString : (void *) aSourceString
          ofLength : (uint8_t) aSourceLength;
@end // @interface QSIEndian (QSIEndianPublicInstanceMethods)
