//
//  QSIBigEndianData.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIBigEndianDataProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIBigEndianData Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIBigEndianData Private Class Methods
//
@interface QSIBigEndianData (QSIBigEndianDataPrivateClassMethods)
@end // @interface QSIBigEndianData (QSIBigEndianDataPrivateClassMethods)

@implementation QSIBigEndianData (QSIBigEndianDataPrivateClassMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataPrivateClassMethods)

//
// QSIBigEndianData Private Instance Methods
//
@interface QSIBigEndianData (QSIBigEndianDataPrivateInstanceMethods)
@end // @interface QSIBigEndianData (QSIBigEndianDataPrivateInstanceMethods)

@implementation QSIBigEndianData (QSIBigEndianDataPrivateInstanceMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIBigEndianData Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIBigEndianData Infrastructure Class Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataInfrastructureClassMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataInfrastructureClassMethods)

//
// QSIBigEndianData Infrastructure Instance Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataInfrastructureInstanceMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIBigEndianData Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIBigEndianData Overridden Class Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataOverriddenClassMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataOverriddenClassMethods)

//
// QSIBigEndianData Overridden Instance Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataOverriddenInstanceMethods)
- (uint16_t) get16BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (((*(source + 0)) << 8) | ((*(source + 1)) << 0));
} // end get16BitsFromSource:

- (uint32_t) get24BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (([self get16BitsFromSource:source] << 16) | ((*(source + 2)) << 0));
} // end -get16BitsFromSource:

- (uint32_t) get32BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (([self get24BitsFromSource:source] << 24) | ((*(source + 3)) << 0));
} // end -get32BitsFromSource:

- (void) set16Bits : (void *) aDestination
         fromValue : (uint16_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 0) = (aValue >> 8) & 0xff;
  *(destination + 1) = (aValue >> 0) & 0xff;
} // end set16Bits:fromValue:

- (void) set24Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 0) = (aValue >> 16) & 0xff;
  [self set16Bits:(destination + 1) fromValue:(aValue & 0xffff)];
} // end set24Bits:fromValue:

- (void) set32Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 0) = (aValue >> 24) & 0xff;
  [self set24Bits:(destination + 1) fromValue:(aValue & 0xffffff)];
} // end set32Bits:fromValue:
@end // @implementation QSIBigEndianData (QSIBigEndianDataOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIBigEndianData Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIBigEndianData Public Class Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataPublicClassMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataPublicClassMethods)

//
// QSIBigEndianData Public Instance Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataPublicInstanceMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIBigEndianData Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIBigEndianData Protected Class Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataProtectedClassMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataProtectedClassMethods)

//
// QSIBigEndianData Protected Instance Methods
//
@implementation QSIBigEndianData (QSIBigEndianDataProtectedInstanceMethods)
@end // @implementation QSIBigEndianData (QSIBigEndianDataProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIBigEndianData
************************************************************************************************
***********************************************************************************************/

@implementation QSIBigEndianData
@end // @implementation QSIBigEndianData
