//
//  QSILittleEndianData.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSILittleEndianDataProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSILittleEndianData Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSILittleEndianData Private Class Methods
//
@interface QSILittleEndianData (QSILittleEndianDataPrivateClassMethods)
@end // @interface QSILittleEndianData (QSILittleEndianDataPrivateClassMethods)

@implementation QSILittleEndianData (QSILittleEndianDataPrivateClassMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataPrivateClassMethods)

//
// QSILittleEndianData Private Instance Methods
//
@interface QSILittleEndianData (QSILittleEndianDataPrivateInstanceMethods)
@end // @interface QSILittleEndianData (QSILittleEndianDataPrivateInstanceMethods)

@implementation QSILittleEndianData (QSILittleEndianDataPrivateInstanceMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSILittleEndianData Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSILittleEndianData Infrastructure Class Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataInfrastructureClassMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataInfrastructureClassMethods)

//
// QSILittleEndianData Infrastructure Instance Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataInfrastructureInstanceMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSILittleEndianData Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSILittleEndianData Overridden Class Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataOverriddenClassMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataOverriddenClassMethods)

//
// QSILittleEndianData Overridden Instance Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataOverriddenInstanceMethods)
- (uint16_t) get16BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (((*(source + 1)) << 8) | ((*(source + 0)) << 0));
} // end get16BitsFromSource:

- (uint32_t) get24BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (([self get16BitsFromSource:(source + 1)] << 16) | ((*(source + 0)) << 0));
} // end -get16BitsFromSource:

- (uint32_t) get32BitsFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return (([self get24BitsFromSource:(source + 1)] << 24) | ((*(source + 0)) << 0));
} // end -get32BitsFromSource:

- (void) set16Bits : (void *) aDestination
         fromValue : (uint16_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 1) = (aValue >> 8) & 0xff;
  *(destination + 0) = (aValue >> 0) & 0xff;
} // end set16Bits:fromValue:

- (void) set24Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 2) = (aValue >> 16) & 0xff;
  [self set16Bits:destination fromValue:(aValue & 0xffff)];
} // end set24Bits:fromValue:

- (void) set32Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  *(destination + 3) = (aValue >> 24) & 0xff;
  [self set24Bits:destination fromValue:(aValue & 0xffffff)];
} // end set32Bits:fromValue:
@end // @implementation QSILittleEndianData (QSILittleEndianDataOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSILittleEndianData Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSILittleEndianData Public Class Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataPublicClassMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataPublicClassMethods)

//
// QSILittleEndianData Public Instance Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataPublicInstanceMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSILittleEndianData Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSILittleEndianData Protected Class Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataProtectedClassMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataProtectedClassMethods)

//
// QSILittleEndianData Protected Instance Methods
//
@implementation QSILittleEndianData (QSILittleEndianDataProtectedInstanceMethods)
@end // @implementation QSILittleEndianData (QSILittleEndianDataProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSILittleEndianData
************************************************************************************************
***********************************************************************************************/

@implementation QSILittleEndianData
@end // @implementation QSILittleEndianData
