//
//  QSIObject.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObjectProtected.h"

#import <objc/runtime.h>

/***********************************************************************************************
************************************************************************************************
* QSIObject Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIObject Private Class Methods
//
@interface QSIObject (QSIObjectPrivateClassMethods)
@end // @interface QSIObject (QSIObjectPrivateClassMethods)

@implementation QSIObject (QSIObjectPrivateClassMethods)
@end // @implementation QSIObject (QSIObjectPrivateClassMethods)

//
// QSIObject Private Instance Methods
//
@interface QSIObject (QSIObjectPrivateInstanceMethods)
@end // @interface QSIObject (QSIObjectPrivateInstanceMethods)

@implementation QSIObject (QSIObjectPrivateInstanceMethods)
@end // @implementation QSIObject (QSIObjectPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIObject Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIObject Infrastructure Class Methods
//
@implementation QSIObject (QSIObjectInfrastructureClassMethods)
@end // @implementation QSIObject (QSIObjectInfrastructureClassMethods)

//
// QSIObject Infrastructure Instance Methods
//
@implementation QSIObject (QSIObjectInfrastructureInstanceMethods)
@end // @implementation QSIObject (QSIObjectInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIObject Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIObject Overridden Class Methods
//
@implementation QSIObject (QSIObjectOverriddenClassMethods)
@end // @implementation QSIObject (QSIObjectOverriddenClassMethods)

//
// QSIObject Overridden Instance Methods
//
@implementation QSIObject (QSIObjectOverriddenInstanceMethods)
@end // @implementation QSIObject (QSIObjectOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIObject Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIObject Public Class Methods
//
@implementation QSIObject (QSIObjectPublicClassMethods)
+ (Class) classNamed : (NSString *) aName
{
  return (objc_getClass([aName cStringUsingEncoding:NSASCIIStringEncoding]));
} // end +classNamed:
@end // @implementation QSIObject (QSIObjectPublicClassMethods)

//
// QSIObject Public Instance Methods
//
@implementation QSIObject (QSIObjectPublicInstanceMethods)
@end // @implementation QSIObject (QSIObjectPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIObject Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIObject Protected Class Methods
//
@implementation QSIObject (QSIObjectProtectedClassMethods)
@end // @implementation QSIObject (QSIObjectProtectedClassMethods)

//
// QSIObject Protected Instance Methods
//
@implementation QSIObject (QSIObjectProtectedInstanceMethods)
@end // @implementation QSIObject (QSIObjectProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIObject
************************************************************************************************
***********************************************************************************************/

@implementation QSIObject
@end // @implementation QSIObject
