//
//  QSIComms.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

#import <IOKit/IOCFPlugIn.h>

@protocol QSIComms
- (QSIStatus) disconnect;
- (bool)      isConnected;
@end // @protocol QSIComms

@interface QSIComms : QSIObject <QSIComms>
{
@private
  uint16_t        _currentReadTimeout;
  uint16_t        _currentWriteTimeout;

  IUnknownVTbl *  *_deviceInterface;

  uint16_t        _extendedReadTimeout;
  uint16_t        _extendedWriteTimeout;
  uint16_t        _shortReadTimeout;
  uint16_t        _shortWriteTimeout;
  uint16_t        _standardReadTimeout;
  uint16_t        _standardWriteTimeout;

  bool            _isConnected;
}
@end // @interface QSIComms : QSIObject <QSIComms>

@interface QSIComms (QSICommsPublicClassMethods)
+ (NSArray *) findAllCameras;
@end // @interface QSIComms (QSICommsPublicClassMethods)

@interface QSIComms (QSICommsPublicInstanceMethods)
- (QSIStatus) connect;

- (uint16_t) extendedReadTimeout;
- (uint16_t) extendedWriteTimeout;

- (QSIStatus) purge;

- (QSIStatus) readToBuffer : (void *) aBuffer
             numberOfBytes : (uint32_t *) aNumberOfBytes;

- (QSIStatus) setReadTimeout : (uint16_t) aReadTimeout
             andWriteTimeout : (uint16_t) aWriteTimeout;

- (QSIStatus) setToExtendedTimeouts;
- (QSIStatus) setToShortTimeouts;
- (QSIStatus) setToStandardTimeouts;

- (uint16_t) shortReadTimeout;
- (uint16_t) shortWriteTimeout;

- (uint16_t) standardReadTimeout;
- (uint16_t) standardWriteTimeout;

- (QSIStatus) writeFromBuffer : (void *) aBuffer
                numberOfBytes : (uint32_t *) aNumberOfBytes;
@end // @interface QSIComms (QSICommsPublicInstanceMethods)
