//
//  QSI500USBComms.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI500USBCommsProtected.h"

#import "QSI500Camera.h"

#import <IOKit/IOCFPlugIn.h>

/***********************************************************************************************
************************************************************************************************
* QSI500USBComms Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500USBComms Private Class Methods
//
@interface QSI500USBComms (QSI500USBCommsPrivateClassMethods)
@end // @interface QSI500USBComms (QSI500USBCommsPrivateClassMethods)

@implementation QSI500USBComms (QSI500USBCommsPrivateClassMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsPrivateClassMethods)

//
// QSI500USBComms Private Instance Methods
//
@interface QSI500USBComms (QSI500USBCommsPrivateInstanceMethods)
@end // @interface QSI500USBComms (QSI500USBCommsPrivateInstanceMethods)

@implementation QSI500USBComms (QSI500USBCommsPrivateInstanceMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI500USBComms Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500USBComms Infrastructure Class Methods
//
@implementation QSI500USBComms (QSI500USBCommsInfrastructureClassMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsInfrastructureClassMethods)

//
// QSI500USBComms Infrastructure Instance Methods
//
@implementation QSI500USBComms (QSI500USBCommsInfrastructureInstanceMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI500USBComms Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500USBComms Overridden Class Methods
//
@implementation QSI500USBComms (QSI500USBCommsOverriddenClassMethods)
+ (Class) cameraClassFromDeviceInterface : (IUnknownVTbl * *) aDeviceInterface
{
  QSIDebugLog(@"looking up camera class using device interface: %p", aDeviceInterface);

  Class cameraClass = nil;

  QSI500USBComms  *comms  = [[[QSI500USBComms alloc] initWithDeviceInterface:aDeviceInterface
                                                            shortReadTimeout:[QSI500Camera shortReadTimeout]
                                                           shortWriteTimeout:[QSI500Camera shortWriteTimeout]
                                                         standardReadTimeout:[QSI500Camera standardReadTimeout]
                                                        standardWriteTimeout:[QSI500Camera standardWriteTimeout]
                                                         extendedReadTimeout:[QSI500Camera extendedReadTimeout]
                                                     andExtendedWriteTimeout:[QSI500Camera extendedWriteTimeout]] autorelease];

  if (comms != nil)
  {
    cameraClass = [QSI500Camera cameraClassFromComms:comms];
  }

  return (cameraClass);
} // end +cameraClassFromDeviceInterface:

+ (NSArray *) findAllCameras
{
  QSIDebugLog(@"looking for 500-series cameras");

  return ([self findAllCamerasWithVendorId:[QSI500Camera usbVendorId] andProductId:[QSI500Camera usbProductId]]);
} // end +findAllCameras
@end // @implementation QSI500USBComms (QSI500USBCommsOverriddenClassMethods)

//
// QSI500USBComms Overridden Instance Methods
//
@implementation QSI500USBComms (QSI500USBCommsOverriddenInstanceMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI500USBComms Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500USBComms Public Class Methods
//
@implementation QSI500USBComms (QSI500USBCommsPublicClassMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsPublicClassMethods)

//
// QSI500USBComms Public Instance Methods
//
@implementation QSI500USBComms (QSI500USBCommsPublicInstanceMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI500USBComms Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500USBComms Protected Class Methods
//
@implementation QSI500USBComms (QSI500USBCommsProtectedClassMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsProtectedClassMethods)

//
// QSI500USBComms Protected Instance Methods
//
@implementation QSI500USBComms (QSI500USBCommsProtectedInstanceMethods)
@end // @implementation QSI500USBComms (QSI500USBCommsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI500USBComms
************************************************************************************************
***********************************************************************************************/

@implementation QSI500USBComms
@end // @implementation QSI500USBComms
