//
//  QSI600USBComms.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI600USBCommsProtected.h"

#import "QSI600Camera.h"

#import <IOKit/IOCFPlugIn.h>

/***********************************************************************************************
************************************************************************************************
* QSI600USBComms Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600USBComms Private Class Methods
//
@interface QSI600USBComms (QSI600USBCommsPrivateClassMethods)
@end // @interface QSI600USBComms (QSI600USBCommsPrivateClassMethods)

@implementation QSI600USBComms (QSI600USBCommsPrivateClassMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsPrivateClassMethods)

//
// QSI600USBComms Private Instance Methods
//
@interface QSI600USBComms (QSI600USBCommsPrivateInstanceMethods)
- (QSIStatus) bondDeviceInterfaces;
@end // @interface QSI600USBComms (QSI600USBCommsPrivateInstanceMethods)

@implementation QSI600USBComms (QSI600USBCommsPrivateInstanceMethods)
- (QSIStatus) bondDeviceInterfaces
{
  QSIStatus status  = QSISuccess;

  status = [self sendControlRequest:QSI600USBDeviceRequestSetBitmode
                             ofType:USBmakebmRequestType(kUSBOut, kUSBVendor, kUSBDevice)
                          withValue:QSI600USBDeviceSetBitmodeBondInterfaces
                              index:0 // use first interface
                         andTimeout:[self writeTimeout]];

  return (status);
} // end -bondDeviceInterfaces
@end // @implementation QSI600USBComms (QSI600USBCommsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI600USBComms Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600USBComms Infrastructure Class Methods
//
@implementation QSI600USBComms (QSI600USBCommsInfrastructureClassMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsInfrastructureClassMethods)

//
// QSI600USBComms Infrastructure Instance Methods
//
@implementation QSI600USBComms (QSI600USBCommsInfrastructureInstanceMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI600USBComms Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600USBComms Overridden Class Methods
//
@implementation QSI600USBComms (QSI600USBCommsOverriddenClassMethods)
+ (Class) cameraClassFromDeviceInterface : (IUnknownVTbl * *) aDeviceInterface
{
  QSIDebugLog(@"looking up camera class using device interface: %p", aDeviceInterface);

  Class cameraClass = nil;

  QSI600USBComms  *comms  = [[[QSI600USBComms alloc] initWithDeviceInterface:aDeviceInterface
                                                            shortReadTimeout:[QSI600Camera shortReadTimeout]
                                                           shortWriteTimeout:[QSI600Camera shortWriteTimeout]
                                                         standardReadTimeout:[QSI600Camera standardReadTimeout]
                                                        standardWriteTimeout:[QSI600Camera standardWriteTimeout]
                                                         extendedReadTimeout:[QSI600Camera extendedReadTimeout]
                                                     andExtendedWriteTimeout:[QSI600Camera extendedWriteTimeout]] autorelease];

  if (comms != nil)
  {
    cameraClass = [QSI600Camera cameraClassFromComms:comms];
  }

  return (cameraClass);
} // end +cameraClassFromDeviceInterface:

+ (NSArray *) findAllCameras
{
  QSIDebugLog(@"looking for 600-series cameras");

  return ([self findAllCamerasWithVendorId:[QSI600Camera usbVendorId] andProductId:[QSI600Camera usbProductId]]);
} // end +findAllCameras
@end // @implementation QSI600USBComms (QSI600USBCommsOverriddenClassMethods)

//
// QSI600USBComms Overridden Instance Methods
//
@implementation QSI600USBComms (QSI600USBCommsOverriddenInstanceMethods)
- (QSIStatus) connectDevice
{
  QSIStatus status  = QSISuccess;

  status = [super connectDevice];
  if (status == QSISuccess)
  {
    status = [self bondDeviceInterfaces];
    if (status != QSISuccess)
    {
      QSIStatus status2 = [self disconnectDevice];

      if (status2 != QSISuccess)
      {
        status = status2;
      }
    }
  }

  return (status);
} // end -connectDevice:
@end // @implementation QSI600USBComms (QSI600USBCommsOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI600USBComms Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600USBComms Public Class Methods
//
@implementation QSI600USBComms (QSI600USBCommsPublicClassMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsPublicClassMethods)

//
// QSI600USBComms Public Instance Methods
//
@implementation QSI600USBComms (QSI600USBCommsPublicInstanceMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI600USBComms Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600USBComms Protected Class Methods
//
@implementation QSI600USBComms (QSI600USBCommsProtectedClassMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsProtectedClassMethods)

//
// QSI600USBComms Protected Instance Methods
//
@implementation QSI600USBComms (QSI600USBCommsProtectedInstanceMethods)
@end // @implementation QSI600USBComms (QSI600USBCommsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI600USBComms
************************************************************************************************
***********************************************************************************************/

@implementation QSI600USBComms
@end // @implementation QSI600USBComms
