//
//  QSICameraDetails.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

@interface QSICameraDetails : QSIObject <NSCopying>
{
@private
  uint16_t  _arrayColumns;
  uint16_t  _arrayRows;
  bool      _hasCamera;
  bool      _hasFilterWheel;
  bool      _hasRelays;
  bool      _hasShutter;
  bool      _hasTemperatureRegulator;
  uint8_t   _maxHorizontalBinning;
  uint8_t   _maxVerticalBinning;
  NSString  *_modelName;
  NSString  *_modelNumber;
  uint8_t   _numberOfFilters;
  uint16_t  _numberOfRowsPerBlock;
  bool      _perBlockControl;
  double    _pixelHeight;
  double    _pixelWidth;
  bool      _powerOfTwoBinning;
  NSString  *_serialNumber;
  bool      _supportsAsymmetricBinning;
}

@property (nonatomic, assign) uint16_t  _arrayColumns;
@property (nonatomic, assign) uint16_t  _arrayRows;
@property (nonatomic, assign) bool      _hasCamera;
@property (nonatomic, assign) bool      _hasFilterWheel;
@property (nonatomic, assign) bool      _hasRelays;
@property (nonatomic, assign) bool      _hasShutter;
@property (nonatomic, assign) bool      _hasTemperatureRegulator;
@property (nonatomic, assign) uint8_t   _maxHorizontalBinning;
@property (nonatomic, assign) uint8_t   _maxVerticalBinning;
@property (nonatomic, retain) NSString  *_modelName;
@property (nonatomic, retain) NSString  *_modelNumber;
@property (nonatomic, assign) uint8_t   _numberOfFilters;
@property (nonatomic, assign) uint16_t  _numberOfRowsPerBlock;
@property (nonatomic, assign) bool      _perBlockControl;
@property (nonatomic, assign) double    _pixelHeight;
@property (nonatomic, assign) double    _pixelWidth;
@property (nonatomic, assign) bool      _powerOfTwoBinning;
@property (nonatomic, retain) NSString  *_serialNumber;
@property (nonatomic, assign) bool      _supportsAsymmetricBinning;

@end // @interface QSICameraDetails : QSIObject <NSCopying>

@interface QSICameraDetails (QSICameraDetailsPublicClassMethods)
@end // @interface QSICameraDetails (QSICameraDetailsPublicClassMethods)

@interface QSICameraDetails (QSICameraDetailsPublicInstanceMethods)
@end // @interface QSICameraDetails (QSICameraDetailsPublicInstanceMethods)
