//
//  QSICameraDeviceState.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

// Highest priority at top of list
typedef enum
{
  deviceStateError,                     // Camera is not available
  deviceStateFilterWheelMoving,         // Waiting for filter wheel to finish moving
  deviceStateFlushing,                  // Flushing CCD chip or camera otherwise busy
  deviceStateWaitingOnExternalTrigger,  // Waiting for an external trigger event
  deviceStateDownloadingImage,          // Downloading the image from camera hardware
  deviceStateReading,                   // Reading the CCD chip into camera hardware
  deviceStateExposing,                  // Exposing dark or light frame
  deviceStateIdle                       // Camera idle
} QSICameraDeviceStateEnum;

@interface QSICameraDeviceState : QSIObject <NSCopying>
{
@private
  QSICameraDeviceStateEnum  _cameraState;
  bool                      _filterState;
  bool                      _shutterOpen;
}

@property (nonatomic, assign) QSICameraDeviceStateEnum  _cameraState;
@property (nonatomic, assign) bool                      _filterState;
@property (nonatomic, assign) bool                      _shutterOpen;

@end // @interface QSICameraDeviceState : QSIObject <NSCopying>

@interface QSICameraDeviceState (QSICameraDeviceStatePublicClassMethods)
@end // @interface QSICameraDeviceState (QSICameraDeviceStatePublicClassMethods)

@interface QSICameraDeviceState (QSICameraDeviceStatePublicInstanceMethods)
@end // @interface QSICameraDeviceState (QSICameraDeviceStatePublicInstanceMethods)
