//
//  QSI500Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI500CameraProtected.h"
#import "QSI500USBComms.h"

/***********************************************************************************************
************************************************************************************************
* QSI500Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500Camera Private Class Methods
//
@interface QSI500Camera (QSI500CameraPrivateClassMethods)
@end // @interface QSI500Camera (QSI500CameraPrivateClassMethods)

@implementation QSI500Camera (QSI500CameraPrivateClassMethods)
@end // @implementation QSI500Camera (QSI500CameraPrivateClassMethods)

//
// QSI500Camera Private Instance Methods
//
@interface QSI500Camera (QSI500CameraPrivateInstanceMethods)
@end // @interface QSI500Camera (QSI500CameraPrivateInstanceMethods)

@implementation QSI500Camera (QSI500CameraPrivateInstanceMethods)
@end // @implementation QSI500Camera (QSI500CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI500Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500Camera Infrastructure Class Methods
//
@implementation QSI500Camera (QSI500CameraInfrastructureClassMethods)
@end // @implementation QSI500Camera (QSI500CameraInfrastructureClassMethods)

//
// QSI500Camera Infrastructure Instance Methods
//
@implementation QSI500Camera (QSI500CameraInfrastructureInstanceMethods)
@end // @implementation QSI500Camera (QSI500CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI500Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500Camera Overridden Class Methods
//
@implementation QSI500Camera (QSI500CameraOverriddenClassMethods)
+ (NSString *) seriesNumber
{
  return (@"500");
} // end +seriesNumber
@end // @implementation QSI500Camera (QSI500CameraOverriddenClassMethods)

//
// QSI500Camera Overridden Instance Methods
//
@implementation QSI500Camera (QSI500CameraOverriddenInstanceMethods)
- (QSIStatus) pulseGuide : (QSICameraGuiding) aGuideDirection
            withDuration : (uint16_t) aDuration
{
  QSIStatus status   = QSISuccess;

  // 500 series cameras are limited to a duration of 50,000 milliseconds.
  if (aDuration > 50000)
  {
    QSILog(@"500-series cameras are limited to 50,000 msec; %d specified", aDuration);

    aDuration = 50000;
  }

  status = [super pulseGuide:aGuideDirection withDuration:aDuration];

  return (status);
} // end -pulseGuide:withDuration:
@end // @implementation QSI500Camera (QSI500CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI500Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500Camera Public Class Methods
//
@implementation QSI500Camera (QSI500CameraPublicClassMethods)
+ (int32_t) usbVendorId
{
  return (0x403); // FTDI; used by QSI
} // end +usbVendorId

+ (int32_t) usbProductId
{
  // The QSI Series 500 USB product ID.
  return (0xeb48);
} // end +usbProductId
@end // @implementation QSI500Camera (QSI500CameraPublicClassMethods)

//
// QSI500Camera Public Instance Methods
//
@implementation QSI500Camera (QSI500CameraPublicInstanceMethods)
@end // @implementation QSI500Camera (QSI500CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI500Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI500Camera Protected Class Methods
//
@implementation QSI500Camera (QSI500CameraProtectedClassMethods)
@end // @implementation QSI500Camera (QSI500CameraProtectedClassMethods)

//
// QSI500Camera Protected Instance Methods
//
@implementation QSI500Camera (QSI500CameraProtectedInstanceMethods)
@end // @implementation QSI500Camera (QSI500CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI500Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI500Camera
@end // @implementation QSI500Camera
