//
//  QSI503Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI503CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI503Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI503Camera Private Class Methods
//
@interface QSI503Camera (QSI503CameraPrivateClassMethods)
@end // @interface QSI503Camera (QSI503CameraPrivateClassMethods)

@implementation QSI503Camera (QSI503CameraPrivateClassMethods)
@end // @implementation QSI503Camera (QSI503CameraPrivateClassMethods)

//
// QSI503Camera Private Instance Methods
//
@interface QSI503Camera (QSI503CameraPrivateInstanceMethods)
@end // @interface QSI503Camera (QSI503CameraPrivateInstanceMethods)

@implementation QSI503Camera (QSI503CameraPrivateInstanceMethods)
@end // @implementation QSI503Camera (QSI503CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI503Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI503Camera Infrastructure Class Methods
//
@implementation QSI503Camera (QSI503CameraInfrastructureClassMethods)
@end // @implementation QSI503Camera (QSI503CameraInfrastructureClassMethods)

//
// QSI503Camera Infrastructure Instance Methods
//
@implementation QSI503Camera (QSI503CameraInfrastructureInstanceMethods)
@end // @implementation QSI503Camera (QSI503CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI503Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI503Camera Overridden Class Methods
//
@implementation QSI503Camera (QSI503CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI503Camera (QSI503CameraOverriddenClassMethods)

//
// QSI503Camera Overridden Instance Methods
//
@implementation QSI503Camera (QSI503CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 2.6;
    aCCDSpecs._electronsPerADULow  = 2.6;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI503Camera (QSI503CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI503Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI503Camera Public Class Methods
//
@implementation QSI503Camera (QSI503CameraPublicClassMethods)
@end // @implementation QSI503Camera (QSI503CameraPublicClassMethods)

//
// QSI503Camera Public Instance Methods
//
@implementation QSI503Camera (QSI503CameraPublicInstanceMethods)
@end // @implementation QSI503Camera (QSI503CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI503Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI503Camera Protected Class Methods
//
@implementation QSI503Camera (QSI503CameraProtectedClassMethods)
@end // @implementation QSI503Camera (QSI503CameraProtectedClassMethods)

//
// QSI503Camera Protected Instance Methods
//
@implementation QSI503Camera (QSI503CameraProtectedInstanceMethods)
@end // @implementation QSI503Camera (QSI503CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI503Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI503Camera
@end // @implementation QSI503Camera
