//
//  QSI504Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI504CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI504Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI504Camera Private Class Methods
//
@interface QSI504Camera (QSI504CameraPrivateClassMethods)
@end // @interface QSI504Camera (QSI504CameraPrivateClassMethods)

@implementation QSI504Camera (QSI504CameraPrivateClassMethods)
@end // @implementation QSI504Camera (QSI504CameraPrivateClassMethods)

//
// QSI504Camera Private Instance Methods
//
@interface QSI504Camera (QSI504CameraPrivateInstanceMethods)
@end // @interface QSI504Camera (QSI504CameraPrivateInstanceMethods)

@implementation QSI504Camera (QSI504CameraPrivateInstanceMethods)
@end // @implementation QSI504Camera (QSI504CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI504Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI504Camera Infrastructure Class Methods
//
@implementation QSI504Camera (QSI504CameraInfrastructureClassMethods)
@end // @implementation QSI504Camera (QSI504CameraInfrastructureClassMethods)

//
// QSI504Camera Infrastructure Instance Methods
//
@implementation QSI504Camera (QSI504CameraInfrastructureInstanceMethods)
@end // @implementation QSI504Camera (QSI504CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI504Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI504Camera Overridden Class Methods
//
@implementation QSI504Camera (QSI504CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI504Camera (QSI504CameraOverriddenClassMethods)

//
// QSI504Camera Overridden Instance Methods
//
@implementation QSI504Camera (QSI504CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 2.6;
    aCCDSpecs._electronsPerADULow  = 2.6;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI504Camera (QSI504CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI504Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI504Camera Public Class Methods
//
@implementation QSI504Camera (QSI504CameraPublicClassMethods)
@end // @implementation QSI504Camera (QSI504CameraPublicClassMethods)

//
// QSI504Camera Public Instance Methods
//
@implementation QSI504Camera (QSI504CameraPublicInstanceMethods)
@end // @implementation QSI504Camera (QSI504CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI504Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI504Camera Protected Class Methods
//
@implementation QSI504Camera (QSI504CameraProtectedClassMethods)
@end // @implementation QSI504Camera (QSI504CameraProtectedClassMethods)

//
// QSI504Camera Protected Instance Methods
//
@implementation QSI504Camera (QSI504CameraProtectedInstanceMethods)
@end // @implementation QSI504Camera (QSI504CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI504Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI504Camera
@end // @implementation QSI504Camera
