//
//  QSI520Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI520CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI520Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI520Camera Private Class Methods
//
@interface QSI520Camera (QSI520CameraPrivateClassMethods)
@end // @interface QSI520Camera (QSI520CameraPrivateClassMethods)

@implementation QSI520Camera (QSI520CameraPrivateClassMethods)
@end // @implementation QSI520Camera (QSI520CameraPrivateClassMethods)

//
// QSI520Camera Private Instance Methods
//
@interface QSI520Camera (QSI520CameraPrivateInstanceMethods)
@end // @interface QSI520Camera (QSI520CameraPrivateInstanceMethods)

@implementation QSI520Camera (QSI520CameraPrivateInstanceMethods)
@end // @implementation QSI520Camera (QSI520CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI520Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI520Camera Infrastructure Class Methods
//
@implementation QSI520Camera (QSI520CameraInfrastructureClassMethods)
@end // @implementation QSI520Camera (QSI520CameraInfrastructureClassMethods)

//
// QSI520Camera Infrastructure Instance Methods
//
@implementation QSI520Camera (QSI520CameraInfrastructureInstanceMethods)
@end // @implementation QSI520Camera (QSI520CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI520Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI520Camera Overridden Class Methods
//
@implementation QSI520Camera (QSI520CameraOverriddenClassMethods)
@end // @implementation QSI520Camera (QSI520CameraOverriddenClassMethods)

//
// QSI520Camera Overridden Instance Methods
//
@implementation QSI520Camera (QSI520CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.8;
    aCCDSpecs._electronsPerADULow  = 1.9;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI520Camera (QSI520CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI520Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI520Camera Public Class Methods
//
@implementation QSI520Camera (QSI520CameraPublicClassMethods)
@end // @implementation QSI520Camera (QSI520CameraPublicClassMethods)

//
// QSI520Camera Public Instance Methods
//
@implementation QSI520Camera (QSI520CameraPublicInstanceMethods)
@end // @implementation QSI520Camera (QSI520CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI520Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI520Camera Protected Class Methods
//
@implementation QSI520Camera (QSI520CameraProtectedClassMethods)
@end // @implementation QSI520Camera (QSI520CameraProtectedClassMethods)

//
// QSI520Camera Protected Instance Methods
//
@implementation QSI520Camera (QSI520CameraProtectedInstanceMethods)
@end // @implementation QSI520Camera (QSI520CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI520Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI520Camera
@end // @implementation QSI520Camera
