//
//  QSI583Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI583CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI583Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583Camera Private Class Methods
//
@interface QSI583Camera (QSI583CameraPrivateClassMethods)
@end // @interface QSI583Camera (QSI583CameraPrivateClassMethods)

@implementation QSI583Camera (QSI583CameraPrivateClassMethods)
@end // @implementation QSI583Camera (QSI583CameraPrivateClassMethods)

//
// QSI583Camera Private Instance Methods
//
@interface QSI583Camera (QSI583CameraPrivateInstanceMethods)
@end // @interface QSI583Camera (QSI583CameraPrivateInstanceMethods)

@implementation QSI583Camera (QSI583CameraPrivateInstanceMethods)
@end // @implementation QSI583Camera (QSI583CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI583Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583Camera Infrastructure Class Methods
//
@implementation QSI583Camera (QSI583CameraInfrastructureClassMethods)
@end // @implementation QSI583Camera (QSI583CameraInfrastructureClassMethods)

//
// QSI583Camera Infrastructure Instance Methods
//
@implementation QSI583Camera (QSI583CameraInfrastructureInstanceMethods)
@end // @implementation QSI583Camera (QSI583CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI583Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583Camera Overridden Class Methods
//
@implementation QSI583Camera (QSI583CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI583Camera (QSI583CameraOverriddenClassMethods)

//
// QSI583Camera Overridden Instance Methods
//
@implementation QSI583Camera (QSI583CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.5;
    aCCDSpecs._electronsPerADULow  = 1.1;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI583Camera (QSI583CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI583Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583Camera Public Class Methods
//
@implementation QSI583Camera (QSI583CameraPublicClassMethods)
@end // @implementation QSI583Camera (QSI583CameraPublicClassMethods)

//
// QSI583Camera Public Instance Methods
//
@implementation QSI583Camera (QSI583CameraPublicInstanceMethods)
@end // @implementation QSI583Camera (QSI583CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI583Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583Camera Protected Class Methods
//
@implementation QSI583Camera (QSI583CameraProtectedClassMethods)
@end // @implementation QSI583Camera (QSI583CameraProtectedClassMethods)

//
// QSI583Camera Protected Instance Methods
//
@implementation QSI583Camera (QSI583CameraProtectedInstanceMethods)
@end // @implementation QSI583Camera (QSI583CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI583Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI583Camera
@end // @implementation QSI583Camera
