//
//  QSI600Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI600CameraProtected.h"
#import "QSI600USBComms.h"

/***********************************************************************************************
************************************************************************************************
* QSI600Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600Camera Private Class Methods
//
@interface QSI600Camera (QSI600CameraPrivateClassMethods)
@end // @interface QSI600Camera (QSI600CameraPrivateClassMethods)

@implementation QSI600Camera (QSI600CameraPrivateClassMethods)
@end // @implementation QSI600Camera (QSI600CameraPrivateClassMethods)

//
// QSI600Camera Private Instance Methods
//
@interface QSI600Camera (QSI600CameraPrivateInstanceMethods)
@end // @interface QSI600Camera (QSI600CameraPrivateInstanceMethods)

@implementation QSI600Camera (QSI600CameraPrivateInstanceMethods)
@end // @implementation QSI600Camera (QSI600CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI600Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600Camera Infrastructure Class Methods
//
@implementation QSI600Camera (QSI600CameraInfrastructureClassMethods)
@end // @implementation QSI600Camera (QSI600CameraInfrastructureClassMethods)

//
// QSI600Camera Infrastructure Instance Methods
//
@implementation QSI600Camera (QSI600CameraInfrastructureInstanceMethods)
@end // @implementation QSI600Camera (QSI600CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI600Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600Camera Overridden Class Methods
//
@implementation QSI600Camera (QSI600CameraOverriddenClassMethods)
+ (NSString *) seriesNumber
{
  return (@"600");
} // end +seriesNumber
@end // @implementation QSI600Camera (QSI600CameraOverriddenClassMethods)

//
// QSI600Camera Overridden Instance Methods
//
@implementation QSI600Camera (QSI600CameraOverriddenInstanceMethods)
- (QSIStatus) pulseGuide : (QSICameraGuiding) aGuideDirection
            withDuration : (uint16_t) aDuration
{
  QSIStatus status   = QSISuccess;

  // 600 series cameras are limited to a duration of 50,000 milliseconds.
  if (aDuration > 50000)
  {
    QSILog(@"600-series cameras are limited to 50,000 msec; %d specified", aDuration);

    aDuration = 50000;
  }

  status = [super pulseGuide:aGuideDirection withDuration:aDuration];

  return (status);
} // end -pulseGuide:withDuration:
@end // @implementation QSI600Camera (QSI600CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI600Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600Camera Public Class Methods
//
@implementation QSI600Camera (QSI600CameraPublicClassMethods)
+ (int32_t) usbVendorId
{
  return (0x403); // FTDI; used by QSI
} // end +usbVendorId

+ (int32_t) usbProductId
{
  // The QSI Series 600 USB product ID.
  return (0xeb49);
} // end +usbProductId
@end // @implementation QSI600Camera (QSI600CameraPublicClassMethods)

//
// QSI600Camera Public Instance Methods
//
@implementation QSI600Camera (QSI600CameraPublicInstanceMethods)
@end // @implementation QSI600Camera (QSI600CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI600Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI600Camera Protected Class Methods
//
@implementation QSI600Camera (QSI600CameraProtectedClassMethods)
@end // @implementation QSI600Camera (QSI600CameraProtectedClassMethods)

//
// QSI600Camera Protected Instance Methods
//
@implementation QSI600Camera (QSI600CameraProtectedInstanceMethods)
- (QSIStatus) sendAdvancedSettings : (QSICameraAdvancedSettingsParameters *) aParameters
{
  QSIStatus status  = QSISuccess;

  // Have our superclass send the command.
  status = [super sendAdvancedSettings:aParameters];

  // Because the changed values could have impacted the CCD specifications (e.g., electrons/ADU),
  // we need to update the CCD specifications.
  if (status == QSISuccess)
  {
    status = [self updateCCDSpecs];
  }

  return (status);
} // end -sendAdvancedSettings:

@end // @implementation QSI600Camera (QSI600CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI600Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI600Camera
@end // @implementation QSI600Camera
