//
//  QSI616Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI616CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI616Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI616Camera Private Class Methods
//
@interface QSI616Camera (QSI616CameraPrivateClassMethods)
@end // @interface QSI616Camera (QSI616CameraPrivateClassMethods)

@implementation QSI616Camera (QSI616CameraPrivateClassMethods)
@end // @implementation QSI616Camera (QSI616CameraPrivateClassMethods)

//
// QSI616Camera Private Instance Methods
//
@interface QSI616Camera (QSI616CameraPrivateInstanceMethods)
@end // @interface QSI616Camera (QSI616CameraPrivateInstanceMethods)

@implementation QSI616Camera (QSI616CameraPrivateInstanceMethods)
@end // @implementation QSI616Camera (QSI616CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI616Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI616Camera Infrastructure Class Methods
//
@implementation QSI616Camera (QSI616CameraInfrastructureClassMethods)
@end // @implementation QSI616Camera (QSI616CameraInfrastructureClassMethods)

//
// QSI616Camera Infrastructure Instance Methods
//
@implementation QSI616Camera (QSI616CameraInfrastructureInstanceMethods)
@end // @implementation QSI616Camera (QSI616CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI616Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI616Camera Overridden Class Methods
//
@implementation QSI616Camera (QSI616CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI616Camera (QSI616CameraOverriddenClassMethods)

//
// QSI616Camera Overridden Instance Methods
//
@implementation QSI616Camera (QSI616CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 2.6;
    aCCDSpecs._electronsPerADULow  = 2.6;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI616Camera (QSI616CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI616Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI616Camera Public Class Methods
//
@implementation QSI616Camera (QSI616CameraPublicClassMethods)
@end // @implementation QSI616Camera (QSI616CameraPublicClassMethods)

//
// QSI616Camera Public Instance Methods
//
@implementation QSI616Camera (QSI616CameraPublicInstanceMethods)
@end // @implementation QSI616Camera (QSI616CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI616Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI616Camera Protected Class Methods
//
@implementation QSI616Camera (QSI616CameraProtectedClassMethods)
@end // @implementation QSI616Camera (QSI616CameraProtectedClassMethods)

//
// QSI616Camera Protected Instance Methods
//
@implementation QSI616Camera (QSI616CameraProtectedInstanceMethods)
@end // @implementation QSI616Camera (QSI616CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI616Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI616Camera
@end // @implementation QSI616Camera
