//
//  QSI683Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI683CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI683Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI683Camera Private Class Methods
//
@interface QSI683Camera (QSI683CameraPrivateClassMethods)
@end // @interface QSI683Camera (QSI683CameraPrivateClassMethods)

@implementation QSI683Camera (QSI683CameraPrivateClassMethods)
@end // @implementation QSI683Camera (QSI683CameraPrivateClassMethods)

//
// QSI683Camera Private Instance Methods
//
@interface QSI683Camera (QSI683CameraPrivateInstanceMethods)
@end // @interface QSI683Camera (QSI683CameraPrivateInstanceMethods)

@implementation QSI683Camera (QSI683CameraPrivateInstanceMethods)
@end // @implementation QSI683Camera (QSI683CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI683Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI683Camera Infrastructure Class Methods
//
@implementation QSI683Camera (QSI683CameraInfrastructureClassMethods)
@end // @implementation QSI683Camera (QSI683CameraInfrastructureClassMethods)

//
// QSI683Camera Infrastructure Instance Methods
//
@implementation QSI683Camera (QSI683CameraInfrastructureInstanceMethods)
@end // @implementation QSI683Camera (QSI683CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI683Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI683Camera Overridden Class Methods
//
@implementation QSI683Camera (QSI683CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI683Camera (QSI683CameraOverriddenClassMethods)

//
// QSI683Camera Overridden Instance Methods
//
@implementation QSI683Camera (QSI683CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.5;
    aCCDSpecs._electronsPerADULow  = 1.1;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI683Camera (QSI683CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI683Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI683Camera Public Class Methods
//
@implementation QSI683Camera (QSI683CameraPublicClassMethods)
@end // @implementation QSI683Camera (QSI683CameraPublicClassMethods)

//
// QSI683Camera Public Instance Methods
//
@implementation QSI683Camera (QSI683CameraPublicInstanceMethods)
@end // @implementation QSI683Camera (QSI683CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI683Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI683Camera Protected Class Methods
//
@implementation QSI683Camera (QSI683CameraProtectedClassMethods)
@end // @implementation QSI683Camera (QSI683CameraProtectedClassMethods)

//
// QSI683Camera Protected Instance Methods
//
@implementation QSI683Camera (QSI683CameraProtectedInstanceMethods)
@end // @implementation QSI683Camera (QSI683CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI683Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI683Camera
@end // @implementation QSI683Camera
