//
//  QSICameraAdvancedDetails.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraAdvancedDetailsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedDetails Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedDetails Infrastructure Class Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsInfrastructureClassMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsInfrastructureClassMethods)

//
// QSICameraAdvancedDetails Infrastructure Instance Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsInfrastructureInstanceMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedDetails Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedDetails Overridden Class Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsOverriddenClassMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsOverriddenClassMethods)

//
// QSICameraAdvancedDetails Overridden Instance Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsOverriddenInstanceMethods)
- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _antiBloomingEnabled                = no;
    _cameraGainEnabled                  = no;
    _fanModeEnabled                     = yes;
    _ledIndicatorEnabled                = yes;
    _optimizationsEnabled               = no;
    _preExposureFlushEnabled            = yes;
    _showDownloadProgressEnabled        = yes;
    _shutterPriorityEnabled             = no;
    _soundOnEnabled                     = yes;
  }
  
  return (self);
} // end -init
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedDetails Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedDetails Private Class Methods
//
@interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateClassMethods)
@end // @interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateClassMethods)

@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateClassMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateClassMethods)

//
// QSICameraAdvancedDetails Private Instance Methods
//
@interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateInstanceMethods)
@end // @interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateInstanceMethods)

@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateInstanceMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedDetails Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedDetails Protected Class Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsProtectedClassMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsProtectedClassMethods)

//
// QSICameraAdvancedDetails Protected Instance Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraAdvancedDetails *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _antiBloomingEnabled          = anInstance._antiBloomingEnabled;
    _antiBloomingIndex            = anInstance._antiBloomingIndex;
    
    _cameraGainEnabled            = anInstance._cameraGainEnabled;
    _cameraGainIndex              = anInstance._cameraGainIndex;
    
    _fanModeEnabled               = anInstance._fanModeEnabled;
    _fanModeIndex                 = anInstance._fanModeIndex;
    
    _ledIndicatorDefault          = anInstance._ledIndicatorDefault;
    _ledIndicatorEnabled          = anInstance._ledIndicatorEnabled;
    
    _optimizationsEnabled         = anInstance._optimizationsEnabled;
    _optimizeReadoutSpeed         = anInstance._optimizeReadoutSpeed;
    
    _preExposureFlushEnabled      = anInstance._preExposureFlushEnabled;
    _preExposureFlushIndex        = anInstance._preExposureFlushIndex;
    
    _showDownloadProgressDefault  = anInstance._showDownloadProgressDefault;
    _showDownloadProgressEnabled  = anInstance._showDownloadProgressEnabled;
    
    _shutterPriorityEnabled       = anInstance._shutterPriorityEnabled;
    _shutterPriorityIndex         = anInstance._shutterPriorityIndex;
    
    _soundOnDefault               = anInstance._soundOnDefault;
    _soundOnEnabled               = anInstance._soundOnEnabled;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedDetails Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedDetails Public Class Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicClassMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicClassMethods)

//
// QSICameraAdvancedDetails Public Instance Methods
//
@implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicInstanceMethods)
@end // @implementation QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraAdvancedDetails
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraAdvancedDetails

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _antiBloomingEnabled;
@synthesize _antiBloomingIndex;

@synthesize _cameraGainEnabled;
@synthesize _cameraGainIndex;

@synthesize _fanModeEnabled;
@synthesize _fanModeIndex;

@synthesize _ledIndicatorDefault;
@synthesize _ledIndicatorEnabled;

@synthesize _optimizationsEnabled;
@synthesize _optimizeReadoutSpeed;

@synthesize _preExposureFlushEnabled;
@synthesize _preExposureFlushIndex;

@synthesize _showDownloadProgressDefault;
@synthesize _showDownloadProgressEnabled;

@synthesize _shutterPriorityEnabled;
@synthesize _shutterPriorityIndex;

@synthesize _soundOnDefault;
@synthesize _soundOnEnabled;

@end // @implementation QSICameraAdvancedDetails
