//
//  QSICameraAdvancedSettingsParameters.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraAdvancedSettingsParametersProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedSettingsParameters Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedSettingsParameters Infrastructure Class Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersInfrastructureClassMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersInfrastructureClassMethods)

//
// QSICameraAdvancedSettingsParameters Infrastructure Instance Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersInfrastructureInstanceMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedSettingsParameters Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedSettingsParameters Overridden Class Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersOverriddenClassMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersOverriddenClassMethods)

//
// QSICameraAdvancedSettingsParameters Overridden Instance Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersOverriddenInstanceMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedSettingsParameters Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedSettingsParameters Private Class Methods
//
@interface QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateClassMethods)
@end // @interface QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateClassMethods)

@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateClassMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateClassMethods)

//
// QSICameraAdvancedSettingsParameters Private Instance Methods
//
@interface QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateInstanceMethods)
@end // @interface QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateInstanceMethods)

@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateInstanceMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedSettingsParameters Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedSettingsParameters Protected Class Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersProtectedClassMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersProtectedClassMethods)

//
// QSICameraAdvancedSettingsParameters Protected Instance Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraAdvancedSettingsParameters *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _antiBloomingIndex      = anInstance._antiBloomingIndex;
    _cameraGainIndex        = anInstance._cameraGainIndex;
    _fanModeIndex           = anInstance._fanModeIndex;
    _ledIndicatorOn         = anInstance._ledIndicatorOn;
    _optimizeReadoutSpeed   = anInstance._optimizeReadoutSpeed;
    _preExposureFlushIndex  = anInstance._preExposureFlushIndex;
    _showDownloadProgress   = anInstance._showDownloadProgress;
    _shutterPriorityIndex   = anInstance._shutterPriorityIndex;
    _soundOn                = anInstance._soundOn;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAdvancedSettingsParameters Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAdvancedSettingsParameters Public Class Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPublicClassMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPublicClassMethods)

//
// QSICameraAdvancedSettingsParameters Public Instance Methods
//
@implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPublicInstanceMethods)
@end // @implementation QSICameraAdvancedSettingsParameters (QSICameraAdvancedSettingsParametersPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraAdvancedSettingsParameters
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraAdvancedSettingsParameters

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _antiBloomingIndex;
@synthesize _cameraGainIndex;
@synthesize _fanModeIndex;
@synthesize _ledIndicatorOn;
@synthesize _optimizeReadoutSpeed;
@synthesize _preExposureFlushIndex;
@synthesize _showDownloadProgress;
@synthesize _shutterPriorityIndex;
@synthesize _soundOn;

@end // @implementation QSICameraAdvancedSettingsParameters
