//
//  QSICameraAutoZero.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraAutoZeroProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZero Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZero Infrastructure Class Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroInfrastructureClassMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroInfrastructureClassMethods)

//
// QSICameraAutoZero Infrastructure Instance Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroInfrastructureInstanceMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZero Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZero Overridden Class Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroOverriddenClassMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroOverriddenClassMethods)

//
// QSICameraAutoZero Overridden Instance Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroOverriddenInstanceMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZero Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZero Private Class Methods
//
@interface QSICameraAutoZero (QSICameraAutoZeroPrivateClassMethods)
@end // @interface QSICameraAutoZero (QSICameraAutoZeroPrivateClassMethods)

@implementation QSICameraAutoZero (QSICameraAutoZeroPrivateClassMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroPrivateClassMethods)

//
// QSICameraAutoZero Private Instance Methods
//
@interface QSICameraAutoZero (QSICameraAutoZeroPrivateInstanceMethods)
@end // @interface QSICameraAutoZero (QSICameraAutoZeroPrivateInstanceMethods)

@implementation QSICameraAutoZero (QSICameraAutoZeroPrivateInstanceMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZero Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZero Protected Class Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroProtectedClassMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroProtectedClassMethods)

//
// QSICameraAutoZero Protected Instance Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraAutoZero *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _pixelCount   = anInstance._pixelCount;
    _zeroEnabled  = anInstance._zeroEnabled;
    _zeroLevel    = anInstance._zeroLevel;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZero Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZero Public Class Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroPublicClassMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroPublicClassMethods)

//
// QSICameraAutoZero Public Instance Methods
//
@implementation QSICameraAutoZero (QSICameraAutoZeroPublicInstanceMethods)
@end // @implementation QSICameraAutoZero (QSICameraAutoZeroPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraAutoZero
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraAutoZero

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _pixelCount;
@synthesize _zeroEnabled;
@synthesize _zeroLevel;

@end // @implementation QSICameraAutoZero
