//
//  QSICameraAutoZeroControl.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraAutoZeroControlProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZeroControl Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZeroControl Infrastructure Class Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlInfrastructureClassMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlInfrastructureClassMethods)

//
// QSICameraAutoZeroControl Infrastructure Instance Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlInfrastructureInstanceMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZeroControl Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZeroControl Overridden Class Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlOverriddenClassMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlOverriddenClassMethods)

//
// QSICameraAutoZeroControl Overridden Instance Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlOverriddenInstanceMethods)
- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _autoZeroEnabled             = QSIDefaultAutoZeroEnabled;
    _autoZeroMaxADU              = QSIDefaultAutoZeroMaxADU;
    _autoZeroMedian              = QSIDefaultAutoZeroMedian;
    _autoZeroSaturationThreshold = QSIDefaultAutoZeroSaturationThreshold;
    _autoZeroSkipEndPixels       = QSIDefaultAutoZeroSkipEndPixels;
    _autoZeroSkipStartPixels     = QSIDefaultAutoZeroSkipStartPixels;
  }

  return (self);
} // end -init
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZeroControl Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZeroControl Private Class Methods
//
@interface QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateClassMethods)
@end // @interface QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateClassMethods)

@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateClassMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateClassMethods)

//
// QSICameraAutoZeroControl Private Instance Methods
//
@interface QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateInstanceMethods)
@end // @interface QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateInstanceMethods)

@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateInstanceMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZeroControl Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZeroControl Protected Class Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlProtectedClassMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlProtectedClassMethods)

//
// QSICameraAutoZeroControl Protected Instance Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraAutoZeroControl *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _autoZeroEnabled              = anInstance._autoZeroEnabled;
    _autoZeroMaxADU               = anInstance._autoZeroMaxADU;
    _autoZeroMedian               = anInstance._autoZeroMedian;
    _autoZeroSaturationThreshold  = anInstance._autoZeroSaturationThreshold;
    _autoZeroSkipEndPixels        = anInstance._autoZeroSkipEndPixels;
    _autoZeroSkipStartPixels      = anInstance._autoZeroSkipStartPixels;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraAutoZeroControl Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraAutoZeroControl Public Class Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPublicClassMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPublicClassMethods)

//
// QSICameraAutoZeroControl Public Instance Methods
//
@implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPublicInstanceMethods)
@end // @implementation QSICameraAutoZeroControl (QSICameraAutoZeroControlPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraAutoZeroControl
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraAutoZeroControl

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _autoZeroEnabled;
@synthesize _autoZeroMaxADU;
@synthesize _autoZeroMedian;
@synthesize _autoZeroSaturationThreshold;
@synthesize _autoZeroSkipEndPixels;
@synthesize _autoZeroSkipStartPixels;

@end // @implementation QSICameraAutoZeroControl
