//
//  QSICameraCCDSpecs.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraCCDSpecsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraCCDSpecs Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCCDSpecs Infrastructure Class Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsInfrastructureClassMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsInfrastructureClassMethods)

//
// QSICameraCCDSpecs Infrastructure Instance Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsInfrastructureInstanceMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraCCDSpecs Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCCDSpecs Overridden Class Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsOverriddenClassMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsOverriddenClassMethods)

//
// QSICameraCCDSpecs Overridden Instance Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsOverriddenInstanceMethods)
- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _electronsPerADUHigh      = 2.4;
    _electronsPerADULow       = 2.4;
    _fullWell                 = 100000;
    _maxADU                   = 0xffff;
    _maxExposure              = 14400.0;
    _minExposure              = 0.03;
  }
  
  return (self);
} // end -init
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraCCDSpecs Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCCDSpecs Private Class Methods
//
@interface QSICameraCCDSpecs (QSICameraCCDSpecsPrivateClassMethods)
@end // @interface QSICameraCCDSpecs (QSICameraCCDSpecsPrivateClassMethods)

@implementation QSICameraCCDSpecs (QSICameraCCDSpecsPrivateClassMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsPrivateClassMethods)

//
// QSICameraCCDSpecs Private Instance Methods
//
@interface QSICameraCCDSpecs (QSICameraCCDSpecsPrivateInstanceMethods)
@end // @interface QSICameraCCDSpecs (QSICameraCCDSpecsPrivateInstanceMethods)

@implementation QSICameraCCDSpecs (QSICameraCCDSpecsPrivateInstanceMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraCCDSpecs Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCCDSpecs Protected Class Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsProtectedClassMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsProtectedClassMethods)

//
// QSICameraCCDSpecs Protected Instance Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraCCDSpecs *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _electronsPerADUHigh = anInstance._electronsPerADUHigh;
    _electronsPerADULow  = anInstance._electronsPerADULow;
    _fullWell            = anInstance._fullWell;
    _maxADU              = anInstance._maxADU;
    _maxExposure         = anInstance._maxExposure;
    _minExposure         = anInstance._minExposure;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraCCDSpecs Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCCDSpecs Public Class Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsPublicClassMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsPublicClassMethods)

//
// QSICameraCCDSpecs Public Instance Methods
//
@implementation QSICameraCCDSpecs (QSICameraCCDSpecsPublicInstanceMethods)
@end // @implementation QSICameraCCDSpecs (QSICameraCCDSpecsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraCCDSpecs
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraCCDSpecs

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _electronsPerADUHigh;
@synthesize _electronsPerADULow;
@synthesize _fullWell;
@synthesize _maxADU;
@synthesize _maxExposure;
@synthesize _minExposure;

@end // @implementation QSICameraCCDSpecs
