//
//  QSICameraCombinedDetails.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraCombinedDetailsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraCombinedDetails Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCombinedDetails Infrastructure Class Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsInfrastructureClassMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsInfrastructureClassMethods)

//
// QSICameraCombinedDetails Infrastructure Instance Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsInfrastructureInstanceMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraCombinedDetails Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCombinedDetails Overridden Class Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsOverriddenClassMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsOverriddenClassMethods)

//
// QSICameraCombinedDetails Overridden Instance Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsOverriddenInstanceMethods)
- (void) dealloc
{
  [_ccdSpecs  release];
  [_details   release];

  [super dealloc];
} // end -dealloc

- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _ccdSpecs = [[QSICameraCCDSpecs alloc] init];
    _details  = [[QSICameraDetails alloc] init];

    if ((_ccdSpecs == nil) || (_details == nil))
    {
      [self release];
      self = nil;
    }
  }

  return (self);
} // end -init
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraCombinedDetails Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCombinedDetails Private Class Methods
//
@interface QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateClassMethods)
@end // @interface QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateClassMethods)

@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateClassMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateClassMethods)

//
// QSICameraCombinedDetails Private Instance Methods
//
@interface QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateInstanceMethods)
@end // @interface QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateInstanceMethods)

@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateInstanceMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraCombinedDetails Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCombinedDetails Protected Class Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsProtectedClassMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsProtectedClassMethods)

//
// QSICameraCombinedDetails Protected Instance Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraCombinedDetails *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _ccdSpecs = [anInstance._ccdSpecs copy];
    _details  = [anInstance._details copy];

    if ((_ccdSpecs == nil) || (_details == nil))
    {
      [self release];
      self = nil;
    }
  }

  return (self);
} // end -initUsingDetails:
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraCombinedDetails Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraCombinedDetails Public Class Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPublicClassMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPublicClassMethods)

//
// QSICameraCombinedDetails Public Instance Methods
//
@implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPublicInstanceMethods)
@end // @implementation QSICameraCombinedDetails (QSICameraCombinedDetailsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraCombinedDetails
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraCombinedDetails

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _ccdSpecs;
@synthesize _details;

@end // @implementation QSICameraCombinedDetails
