//
//  QSICameraDefaults.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"
#import "QSICameraState.h"

@interface QSICameraDefaults : QSIObject
{
@private
  NSString            *_defaultsName;
  NSMutableDictionary *_defaultsDictionary;
}
@end // @interface QSICameraDefaults : QSIObject

@interface QSICameraDefaults (QSICameraDefaultsPublicClassMethods)
@end // @interface QSICameraDefaults (QSICameraDefaultsPublicClassMethods)

@interface QSICameraDefaults (QSICameraDefaultsPublicInstanceMethods)
- (id) initForCameraWithModelNumer : (NSString *) aModelNumber
                   andSerialNumber : (NSString *) aSerialNumber;

- (QSICameraAntiBloom) antiBloom;
- (bool) cooler;
- (double) coolerSetPoint;
- (QSICameraFanMode) fanMode;
- (QSICameraGain) gain;
- (bool) ledAlert;
- (QSICameraPreExposureFlush) preExposureFlush;
- (QSICameraReadoutSpeed) readoutSpeed;
- (QSICameraShutterPriority) shutterPriority;
- (bool) soundAlert;

- (void) setAntiBloom : (QSICameraAntiBloom) anAntiBloom;
- (void) setCooler : (bool) aCooler;
- (void) setCoolerSetPoint : (double) aCoolerSetPoint;
- (void) setFanMode : (QSICameraFanMode) aFanMode;
- (void) setGain : (QSICameraGain) aGain;
- (void) setLEDAlert : (bool) anLEDAlert;
- (void) setPreExposureFlush : (QSICameraPreExposureFlush) aPreExposureFlush;
- (void) setReadoutSpeed : (QSICameraReadoutSpeed) aReadoutSpeed;
- (void) setShutterPriority : (QSICameraShutterPriority) aShutterPriority;
- (void) setSoundAlert : (bool) aSoundAlert;
@end // @interface QSICameraDefaults (QSICameraDefaultsPublicInstanceMethods)
