//
//  QSICameraDefaults.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraDefaultsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraDefaults Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDefaults Infrastructure Class Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsInfrastructureClassMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsInfrastructureClassMethods)

//
// QSICameraDefaults Infrastructure Instance Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsInfrastructureInstanceMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDefaults Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDefaults Overridden Class Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsOverriddenClassMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsOverriddenClassMethods)

//
// QSICameraDefaults Overridden Instance Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsOverriddenInstanceMethods)
- (void) dealloc
{
  [_defaultsName        release];
  [_defaultsDictionary  release];
  
  [super dealloc];
}

- (id) init
{
  [self doesNotRecognizeSelector:_cmd];
  
  return (nil);
} // end -init
@end // @implementation QSICameraDefaults (QSICameraDefaultsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDefaults Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDefaults Private Class Methods
//
@interface QSICameraDefaults (QSICameraDefaultsPrivateClassMethods)
@end // @interface QSICameraDefaults (QSICameraDefaultsPrivateClassMethods)

@implementation QSICameraDefaults (QSICameraDefaultsPrivateClassMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsPrivateClassMethods)

//
// QSICameraDefaults Private Instance Methods
//
@interface QSICameraDefaults (QSICameraDefaultsPrivateInstanceMethods)
@end // @interface QSICameraDefaults (QSICameraDefaultsPrivateInstanceMethods)

@implementation QSICameraDefaults (QSICameraDefaultsPrivateInstanceMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDefaults Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDefaults Protected Class Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsProtectedClassMethods)
+ (NSDictionary *) defaultDictionary
{
  NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
  
  if (dictionary != nil)
  {
    [dictionary setObject:QSICameraAntiBloomDefault         forKey:QSICameraAntiBloomDefaultKey];
    [dictionary setObject:QSICameraCoolerSetPointDefault    forKey:QSICameraCoolerSetPointDefaultKey];
    [dictionary setObject:QSICameraCoolerStateDefault       forKey:QSICameraCoolerStateDefaultKey];
    [dictionary setObject:QSICameraFanModeDefault           forKey:QSICameraFanModeDefaultKey];
    [dictionary setObject:QSICameraGainDefault              forKey:QSICameraGainDefaultKey];
    [dictionary setObject:QSICameraLEDAlertDefault          forKey:QSICameraLEDAlertDefaultKey];
    [dictionary setObject:QSICameraPreExposureFlushDefault  forKey:QSICameraPreExposureFlushDefaultKey];
    [dictionary setObject:QSICameraReadoutSpeedDefault      forKey:QSICameraReadoutSpeedDefaultKey];
    [dictionary setObject:QSICameraShutterPriorityDefault   forKey:QSICameraShutterPriorityDefaultKey];
    [dictionary setObject:QSICameraSoundAlertDefault        forKey:QSICameraSoundAlertDefaultKey];
  }
  
  return (dictionary);
} // end -defaultDictionary
@end // @implementation QSICameraDefaults (QSICameraDefaultsProtectedClassMethods)

//
// QSICameraDefaults Protected Instance Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsProtectedInstanceMethods)
- (void) setObject : (id) anObject
            forKey : (NSString *) aKey
{
  [_defaultsDictionary  setObject:anObject forKey:aKey];
  
  [[NSUserDefaults standardUserDefaults] setObject:_defaultsDictionary forKey:_defaultsName];
  [[NSUserDefaults standardUserDefaults] synchronize];
} // end -setObject:forKey:
@end // @implementation QSICameraDefaults (QSICameraDefaultsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDefaults Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDefaults Public Class Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsPublicClassMethods)
@end // @implementation QSICameraDefaults (QSICameraDefaultsPublicClassMethods)

//
// QSICameraDefaults Public Instance Methods
//
@implementation QSICameraDefaults (QSICameraDefaultsPublicInstanceMethods)
- (id) initForCameraWithModelNumer : (NSString *) aModelNumber
                   andSerialNumber : (NSString *) aSerialNumber
{
  self = [super init];
  if (self != nil)
  {
    _defaultsName = [[NSString stringWithFormat:@"%@-%@", aModelNumber, aSerialNumber] retain];
    if (_defaultsName == nil)
    {
      [self release];
      self = nil;
    }
  }
  
  // Get the user defaults.
  NSUserDefaults  *userDefaults = nil;
  if (self != nil)
  {
    userDefaults = [NSUserDefaults standardUserDefaults];
    if (userDefaults == nil)
    {
      [self release];
      self = nil;
    }
  }

  // Get the dictionary for the camera, creating one if one doesn't
  // exist.
  NSDictionary  *dictionary = nil;
  if (self != nil)
  {
    dictionary = [userDefaults dictionaryForKey:_defaultsName];

    if (dictionary == nil)
    {
      // Create the dictionary.
      dictionary = [[self class] defaultDictionary];
      if (dictionary != nil)
      {
        [userDefaults setObject:dictionary forKey:_defaultsName];
        [userDefaults synchronize];
      }
    }
    
    if (dictionary == nil)
    {
      [self release];
      self = nil;
    }
  }
  
  // Create the mutable dictionary with the contents of the camera's dictionary.
  if (self != nil)
  {
    _defaultsDictionary = [[NSMutableDictionary dictionaryWithDictionary:dictionary] retain];
    if (_defaultsDictionary == nil)
    {
      [self release];
      self = nil;
    }
  }
  
  return (self);
} // end -initForCameraWithModelNumber:andSerialNumber:

- (QSICameraAntiBloom) antiBloom
{
  return ((QSICameraAntiBloom) [[_defaultsDictionary objectForKey:QSICameraAntiBloomDefaultKey] integerValue]);
} // end -antiBloom

- (bool) cooler
{
  return ([[_defaultsDictionary objectForKey:QSICameraCoolerStateDefaultKey] integerValue] == 1);
} // end -cooler

- (double) coolerSetPoint
{
  return ([[_defaultsDictionary objectForKey:QSICameraCoolerSetPointDefaultKey] doubleValue]);
} // end -coolerSetPoint

- (QSICameraFanMode) fanMode
{
  return ((QSICameraFanMode) [[_defaultsDictionary objectForKey:QSICameraFanModeDefaultKey] integerValue]);
} // end -fanMode

- (QSICameraGain) gain
{
  return ((QSICameraGain) [[_defaultsDictionary objectForKey:QSICameraGainDefaultKey] integerValue]);
} // end -gain

- (bool) ledAlert
{
  return ([[_defaultsDictionary objectForKey:QSICameraLEDAlertDefaultKey] integerValue] == 1);
} // end -ledAlert

- (QSICameraPreExposureFlush) preExposureFlush
{
  return ((QSICameraPreExposureFlush) [[_defaultsDictionary objectForKey:QSICameraPreExposureFlushDefaultKey] integerValue]);
} // end -preExposureFlush

- (QSICameraReadoutSpeed) readoutSpeed
{
  return ((QSICameraReadoutSpeed) [[_defaultsDictionary objectForKey:QSICameraReadoutSpeedDefaultKey] integerValue]);
} // end -readoutSpeed

- (QSICameraShutterPriority) shutterPriority
{
  return ((QSICameraShutterPriority) [[_defaultsDictionary objectForKey:QSICameraShutterPriorityDefaultKey] integerValue]);
} // end -shutterPriority

- (bool) soundAlert
{
  return ([[_defaultsDictionary objectForKey:QSICameraSoundAlertDefaultKey] integerValue] == 1);
} // end -soundAlert

- (void) setAntiBloom : (QSICameraAntiBloom) anAntiBloom
{
  [self setObject:[NSString stringWithFormat:@"%d", anAntiBloom] forKey:QSICameraAntiBloomDefaultKey];
} // end -setAntiBloom:

- (void) setCooler : (bool) aCooler
{
  [self setObject:[NSString stringWithFormat:@"%d", (aCooler) ? 1 : 0] forKey:QSICameraCoolerStateDefaultKey];
} // end -setCooler:

- (void) setCoolerSetPoint : (double) aCoolerSetPoint
{
  [self setObject:[NSString stringWithFormat:@"%f", aCoolerSetPoint] forKey:QSICameraCoolerSetPointDefaultKey];
} // end -setCoolerSetPoint:

- (void) setFanMode : (QSICameraFanMode) aFanMode
{
  [self setObject:[NSString stringWithFormat:@"%d", aFanMode] forKey:QSICameraFanModeDefaultKey];
} // end -setFanMode:

- (void) setGain : (QSICameraGain) aGain
{
  [self setObject:[NSString stringWithFormat:@"%d", aGain] forKey:QSICameraGainDefaultKey];
} // end -setGain:

- (void) setLEDAlert : (bool) anLEDAlert
{
  [self setObject:[NSString stringWithFormat:@"%d", (anLEDAlert) ? 1 : 0] forKey:QSICameraLEDAlertDefaultKey];
} // end -setLEDAlert:

- (void) setPreExposureFlush : (QSICameraPreExposureFlush) aPreExposureFlush
{
  [self setObject:[NSString stringWithFormat:@"%d", aPreExposureFlush] forKey:QSICameraPreExposureFlushDefaultKey];
} // end -setPreExposureFlush:

- (void) setReadoutSpeed : (QSICameraReadoutSpeed) aReadoutSpeed
{
  [self setObject:[NSString stringWithFormat:@"%d", aReadoutSpeed] forKey:QSICameraReadoutSpeedDefaultKey];
} // end -setReadoutSpeed:

- (void) setShutterPriority : (QSICameraShutterPriority) aShutterPriority
{
  [self setObject:[NSString stringWithFormat:@"%d", aShutterPriority] forKey:QSICameraShutterPriorityDefaultKey];
} // end -setShutterPriority:

- (void) setSoundAlert : (bool) aSoundAlert
{
  [self setObject:[NSString stringWithFormat:@"%d", (aSoundAlert) ? 1 : 0] forKey:QSICameraSoundAlertDefaultKey];
} // end -setSoundAlert:

@end // @implementation QSICameraDefaults (QSICameraDefaultsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraDefaults
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraDefaults
@end // @implementation QSICameraDefaults
