//
//  QSICameraExposureParameters.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraExposureParametersProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraExposureParameters Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraExposureParameters Infrastructure Class Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersInfrastructureClassMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersInfrastructureClassMethods)

//
// QSICameraExposureParameters Infrastructure Instance Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersInfrastructureInstanceMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraExposureParameters Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraExposureParameters Overridden Class Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersOverriddenClassMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersOverriddenClassMethods)

//
// QSICameraExposureParameters Overridden Instance Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersOverriddenInstanceMethods)
- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _columnBinning        = 1;
    _duration             = 0.5 * 100;
    _durationUsec         = 0;
    _fastReadout          = no;
    _height               = 0;
    _holdShutterOpen      = no;
    _openShutter          = yes;
    _probeForImplemented  = no;
    _repeatCount          = 0;
    _rowBinning           = 1;
    _startingColumn       = 0;
    _startingRow          = 0;
    _strobeShutterOutput  = no;
    _useExternalTrigger   = no;
    _width                = 0;
  }

  return (self);
} // end -init
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraExposureParameters Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraExposureParameters Private Class Methods
//
@interface QSICameraExposureParameters (QSICameraExposureParametersPrivateClassMethods)
@end // @interface QSICameraExposureParameters (QSICameraExposureParametersPrivateClassMethods)

@implementation QSICameraExposureParameters (QSICameraExposureParametersPrivateClassMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersPrivateClassMethods)

//
// QSICameraExposureParameters Private Instance Methods
//
@interface QSICameraExposureParameters (QSICameraExposureParametersPrivateInstanceMethods)
@end // @interface QSICameraExposureParameters (QSICameraExposureParametersPrivateInstanceMethods)

@implementation QSICameraExposureParameters (QSICameraExposureParametersPrivateInstanceMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraExposureParameters Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraExposureParameters Protected Class Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersProtectedClassMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersProtectedClassMethods)

//
// QSICameraExposureParameters Protected Instance Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraExposureParameters *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _columnBinning        = anInstance._columnBinning;
    _duration             = anInstance._duration;
    _durationUsec         = anInstance._durationUsec;
    _fastReadout          = anInstance._fastReadout;
    _height               = anInstance._height;
    _holdShutterOpen      = anInstance._holdShutterOpen;
    _openShutter          = anInstance._openShutter;
    _probeForImplemented  = anInstance._probeForImplemented;
    _repeatCount          = anInstance._repeatCount;
    _rowBinning           = anInstance._rowBinning;
    _startingColumn       = anInstance._startingColumn;
    _startingRow          = anInstance._startingRow;
    _strobeShutterOutput  = anInstance._strobeShutterOutput;
    _useExternalTrigger   = anInstance._useExternalTrigger;
    _width                = anInstance._width;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraExposureParameters Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraExposureParameters Public Class Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersPublicClassMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersPublicClassMethods)

//
// QSICameraExposureParameters Public Instance Methods
//
@implementation QSICameraExposureParameters (QSICameraExposureParametersPublicInstanceMethods)
@end // @implementation QSICameraExposureParameters (QSICameraExposureParametersPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraExposureParameters
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraExposureParameters

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _columnBinning;
@synthesize _duration;
@synthesize _durationUsec;
@synthesize _fastReadout;
@synthesize _height;
@synthesize _holdShutterOpen;
@synthesize _openShutter;
@synthesize _probeForImplemented;
@synthesize _repeatCount;
@synthesize _rowBinning;
@synthesize _startingColumn;
@synthesize _startingRow;
@synthesize _strobeShutterOutput;
@synthesize _useExternalTrigger;
@synthesize _width;

@end // @implementation QSICameraExposureParameters
