//
//  QSICameraProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICamera.h"

@interface QSICamera (QSICameraProtectedClassMethods)
+ (bool) ccdIsKAF;
+ (bool) colorCamera;
+ (NSString *) seriesNumber;
@end // @interface QSICamera (QSICameraProtectedClassMethods)

@interface QSICamera (QSICameraProtectedInstanceMethods)
- (QSIStatus) abortRelays;
- (QSIStatus) activateRelayX : (uint16_t) anX
                        andY : (uint16_t) aY;
- (void) addFilter : (QSIFilter *) aFilter;
- (QSIStatus) adjustZeroByValue : (int16_t) anAdjustment
                         source : (NSMutableData *) aSource
                    destination : (NSMutableData *) aDestination
                      rowLength : (uint32_t) aRowLength
                     rowPadding : (uint32_t) aRowPadding
                  remainingRows : (uint32_t) aRemainingRows;
- (int16_t)   calculateAutoZeroAdjustment : (QSICameraAutoZero *) aCameraAutoZeroData
                           withZeroPixels : (uint16_t *) aZeroPixels
                        andReturnLastMean : (uint16_t *) aLastMean;
- (QSIComms *) commsObject;
- (uint16_t) eepromAccessTimeout;
- (QSIStatus) fillImageBuffer;
- (QSIStatus) getAdvancedDetails : (QSICameraAdvancedDetails *) anAdvancedDetails;
- (QSIStatus) getAltMode1 : (uint8_t *) anAltMode1;
- (QSIStatus) getAutoZero : (QSICameraAutoZero *) anAutoZero;
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs;
- (QSIStatus) getCombinedDetails : (QSICameraCombinedDetails *) aCombinedDetails;
- (QSIStatus) getDetails : (QSICameraDetails *) aDetails;
- (QSIStatus) getDeviceState : (QSICameraDeviceState *) aDeviceState;
- (QSIStatus) getEEPROMData : (uint8_t *) aData
                fromAddress : (uint16_t) anAddress;
- (QSIStatus) getFilterPosition : (uint8_t *) aPosition;
- (QSIStatus) getHardwareVersion : (NSString * *) aHardwareVersion
              andFirmwareVersion : (NSString * *) aFirmwareVersion;
- (QSIStatus) getLastExposure : (double *) aLastExposure;
- (QSIStatus) getSetPoint : (double *) aSetPoint;
- (QSIStatus) getTemperature : (QSICameraTemperature *) aResults;
- (QSIStatus) hasFastExposure : (bool *) aHasFastExposure;
- (QSIStatus) initialize;
- (QSIStatus) isRelayDone : (bool *) aIsDone;
- (QSIStatus) readImage : (void *) aBuffer
          numberOfBytes : (uint32_t) aNumberOfBytes;
- (void) removeAllFilters;
- (QSIStatus) sendAdvancedSettings : (QSICameraAdvancedSettingsParameters *) aParameters;
- (QSIStatus) setAltMode1 : (uint8_t) anAltMode1;
- (QSIStatus) setDefaults;
- (QSIStatus) setFilterWheelPosition : (uint8_t) aPosition;
- (QSIStatus) setShutter : (bool) aOpen;
- (QSIStatus) setTemperature : (QSICameraTemperatureParameters *) aParameters;
- (QSIStatus) startExposure : (QSICameraExposureParameters *) aParameters;
- (QSIStatus) startExposureExtended : (QSICameraExposureParameters *) aParameters;
- (QSIStatus) transferImage;
- (QSIStatus) updateCCDSpecs;

// Methods used in setting up an exposure in order to bypass the automatic
// updating of the camera defaults.
- (QSIStatus) setExposureAntiBlooming : (QSICameraAntiBloom) anAntiBloom;
- (QSIStatus) setExposureGain : (QSICameraGain) aGain;
- (QSIStatus) setExposurePreExposureFlush : (QSICameraPreExposureFlush) aPreExposureFlush;
- (QSIStatus) setExposureReadoutSpeed : (QSICameraReadoutSpeed) aReadoutSpeed;
- (QSIStatus) setExposureShutterPriority : (QSICameraShutterPriority) aShutterPriority;

@end // @interface QSICamera (QSICameraProtectedInstanceMethods)
