//
//  QSICameraTemperature.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraTemperatureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperature Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperature Infrastructure Class Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureInfrastructureClassMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperatureInfrastructureClassMethods)

//
// QSICameraTemperature Infrastructure Instance Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureInfrastructureInstanceMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperatureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperature Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperature Overridden Class Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureOverriddenClassMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperatureOverriddenClassMethods)

//
// QSICameraTemperature Overridden Instance Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureOverriddenInstanceMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperatureOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraTemperature Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperature Private Class Methods
//
@interface QSICameraTemperature (QSICameraTemperaturePrivateClassMethods)
@end // @interface QSICameraTemperature (QSICameraTemperaturePrivateClassMethods)

@implementation QSICameraTemperature (QSICameraTemperaturePrivateClassMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperaturePrivateClassMethods)

//
// QSICameraTemperature Private Instance Methods
//
@interface QSICameraTemperature (QSICameraTemperaturePrivateInstanceMethods)
@end // @interface QSICameraTemperature (QSICameraTemperaturePrivateInstanceMethods)

@implementation QSICameraTemperature (QSICameraTemperaturePrivateInstanceMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperaturePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraTemperature Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperature Protected Class Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureProtectedClassMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperatureProtectedClassMethods)

//
// QSICameraTemperature Protected Instance Methods
//
@implementation QSICameraTemperature (QSICameraTemperatureProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraTemperature *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _ambientTemperature = anInstance._ambientTemperature;
    _coolerPower        = anInstance._coolerPower;
    _coolerState        = anInstance._coolerState;
    _coolerTemperature  = anInstance._coolerTemperature;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraTemperature (QSICameraTemperatureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperature Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperature Public Class Methods
//
@implementation QSICameraTemperature (QSICameraTemperaturePublicClassMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperaturePublicClassMethods)

//
// QSICameraTemperature Public Instance Methods
//
@implementation QSICameraTemperature (QSICameraTemperaturePublicInstanceMethods)
@end // @implementation QSICameraTemperature (QSICameraTemperaturePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraTemperature
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraTemperature

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _ambientTemperature;
@synthesize _coolerPower;
@synthesize _coolerState;
@synthesize _coolerTemperature;

@end // @implementation QSICameraTemperature
