//
//  QSICameraTemperatureParameters.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraTemperatureParametersProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperatureParameters Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperatureParameters Infrastructure Class Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersInfrastructureClassMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersInfrastructureClassMethods)

//
// QSICameraTemperatureParameters Infrastructure Instance Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersInfrastructureInstanceMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperatureParameters Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperatureParameters Overridden Class Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersOverriddenClassMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersOverriddenClassMethods)

//
// QSICameraTemperatureParameters Overridden Instance Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersOverriddenInstanceMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraTemperatureParameters Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperatureParameters Private Class Methods
//
@interface QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateClassMethods)
@end // @interface QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateClassMethods)

@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateClassMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateClassMethods)

//
// QSICameraTemperatureParameters Private Instance Methods
//
@interface QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateInstanceMethods)
@end // @interface QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateInstanceMethods)

@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateInstanceMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraTemperatureParameters Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperatureParameters Protected Class Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersProtectedClassMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersProtectedClassMethods)

//
// QSICameraTemperatureParameters Protected Instance Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraTemperatureParameters *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _coolerOn     = anInstance._coolerOn;
    _goToAmbient  = anInstance._goToAmbient;
    _setPoint     = anInstance._setPoint;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraTemperatureParameters Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraTemperatureParameters Public Class Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPublicClassMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPublicClassMethods)

//
// QSICameraTemperatureParameters Public Instance Methods
//
@implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPublicInstanceMethods)
@end // @implementation QSICameraTemperatureParameters (QSICameraTemperatureParametersPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraTemperatureParameters
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraTemperatureParameters

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _coolerOn;
@synthesize _goToAmbient;
@synthesize _setPoint;

@end // @implementation QSICameraTemperatureParameters
