//
//  QSIFilter.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

@interface QSIFilter : QSIObject
{
@private
  int32_t   _focusOffset;
  NSString  *_name;
  int16_t   _trim;
}
@end // @interface QSIFilter : QSIObject

@interface QSIFilter (QSIFilterPublicClassMethods)
@end // @interface QSIFilter (QSIFilterPublicClassMethods)

@interface QSIFilter (QSIFilterPublicInstanceMethods)
- (id) initWithName : (NSString *) aName;
- (id) initWithName : (NSString *) aName
     andFocusOffset : (int32_t) aFocusOffset;
- (id) initWithName : (NSString *) aName
        focusOffset : (int32_t) aFocusOffset
            andTrim : (int16_t) aTrim;

- (int32_t) focusOffset;
- (NSString *) name;
- (void) setFocusOffset : (int32_t) aFocusOffset;
- (void) setName : (NSString *) aName;
- (void) setTrim : (int16_t) aTrim;
- (int16_t) trim;
@end // @interface QSIFilter (QSIFilterPublicInstanceMethods)
